/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Set;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.ResourceCapabilityReference;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Requirement;

public class TransactionResourceCapabilityReference
extends ResourceCapabilityReference {
    private final Attribute transactionModeAttriute;
    private final Set<TransactionMode> excludedModes;

    public TransactionResourceCapabilityReference(Capability capability, Requirement requirement, Attribute transactionModeAttribute, Set<TransactionMode> excludedModes) {
        super(capability, requirement);
        this.transactionModeAttriute = transactionModeAttribute;
        this.excludedModes = excludedModes;
    }

    public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        if (this.isTransactionalSupportRequired(context, resource)) {
            super.addCapabilityRequirements(context, resource, attributeName, values);
        }
    }

    public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        if (this.isTransactionalSupportRequired(context, resource)) {
            super.removeCapabilityRequirements(context, resource, attributeName, values);
        }
    }

    private boolean isTransactionalSupportRequired(OperationContext context, Resource resource) {
        try {
            TransactionMode mode = (TransactionMode)ModelNodes.asEnum((ModelNode)this.transactionModeAttriute.resolveModelAttribute((ExpressionResolver)context, resource.getModel()), TransactionMode.class);
            return !this.excludedModes.contains((Object)mode);
        }
        catch (RuntimeException | OperationFailedException e) {
            return true;
        }
    }
}

