/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.Properties;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemInitialization;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemSchema;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.subsystem.ClusteringSubsystemTest;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.Versioned;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.jgroups.spi.JGroupsDefaultRequirement;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;

@RunWith(value=Parameterized.class)
public class InfinispanSubsystemTestCase
extends ClusteringSubsystemTest<InfinispanSubsystemSchema> {
    private final InfinispanSubsystemSchema schema;

    @Parameterized.Parameters
    public static Iterable<InfinispanSubsystemSchema> parameters() {
        return EnumSet.allOf(InfinispanSubsystemSchema.class);
    }

    public InfinispanSubsystemTestCase(InfinispanSubsystemSchema schema) {
        super("infinispan", (Extension)new InfinispanExtension(), (SubsystemSchema)schema, "subsystem-infinispan-%d_%d.xml", "schema/jboss-as-infinispan_%d_%d.xsd");
        this.schema = schema;
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new InfinispanSubsystemInitialization().require((UnaryRequirement)CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING, new String[]{"hotrod-server-1", "hotrod-server-2"}).require((UnaryRequirement)CommonUnaryRequirement.DATA_SOURCE, new String[]{"ExampleDS"}).require((UnaryRequirement)CommonUnaryRequirement.PATH, new String[]{"jboss.server.temp.dir"}).require((Requirement)JGroupsDefaultRequirement.CHANNEL_FACTORY).require((Requirement)CommonRequirement.LOCAL_TRANSACTION_PROVIDER).require((Requirement)TransactionResourceDefinition.TransactionRequirement.XA_RESOURCE_RECOVERY_REGISTRY);
    }

    public void testSchemaOfSubsystemTemplates() throws Exception {
    }

    protected void compare(ModelNode model1, ModelNode model2) {
        InfinispanSubsystemTestCase.purgeJGroupsModel(model1);
        InfinispanSubsystemTestCase.purgeJGroupsModel(model2);
        super.compare(model1, model2);
    }

    private static void purgeJGroupsModel(ModelNode model) {
        model.get(JGroupsSubsystemResourceDefinition.PATH.getKey()).remove(JGroupsSubsystemResourceDefinition.PATH.getValue());
    }

    protected Properties getResolvedProperties() {
        Properties properties = new Properties();
        properties.put("java.io.tmpdir", "/tmp");
        return properties;
    }

    protected KernelServices standardSubsystemTest(String configId, String configIdResolvedModel, boolean compareXml, AdditionalInitialization additionalInit) throws Exception {
        KernelServices services = super.standardSubsystemTest(configId, configIdResolvedModel, compareXml, additionalInit);
        if (!this.schema.since((Versioned)InfinispanSubsystemSchema.VERSION_1_5)) {
            ModelNode model = services.readWholeModel();
            Assert.assertTrue((boolean)model.get(InfinispanSubsystemResourceDefinition.PATH.getKey()).hasDefined(InfinispanSubsystemResourceDefinition.PATH.getValue()));
            ModelNode subsystem = model.get(InfinispanSubsystemResourceDefinition.PATH.getKeyValuePair());
            for (Property containerProp : subsystem.get(CacheContainerResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                Assert.assertTrue((String)("cache-container=" + containerProp.getName()), (boolean)containerProp.getValue().get(CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.getName()).asBoolean());
                for (String key : containerProp.getValue().keys()) {
                    ModelNode caches;
                    if (!key.endsWith("-cache") || key.equals("default-cache") || !(caches = containerProp.getValue().get(key)).isDefined()) continue;
                    for (Property cacheProp : caches.asPropertyList()) {
                        Assert.assertTrue((String)("cache-container=" + containerProp.getName() + "," + key + "=" + cacheProp.getName()), (boolean)containerProp.getValue().get(CacheResourceDefinition.Attribute.STATISTICS_ENABLED.getName()).asBoolean());
                    }
                }
            }
        }
        return services;
    }
}

