/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Set;
import java.util.function.Consumer;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceTransformer;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceTransformer;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceTransformer;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceTransformer;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceTransformer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class CacheContainerResourceTransformer
implements Consumer<ModelVersion> {
    private static final Set<String> SERVER_MODULES = Set.of("org.wildfly.clustering.server.infinispan", "org.wildfly.clustering.singleton.server");
    private static final String LEGACY_SERVER_MODULE = "org.wildfly.clustering.server";
    private final ResourceTransformationDescriptionBuilder builder;

    CacheContainerResourceTransformer(ResourceTransformationDescriptionBuilder parent) {
        this.builder = parent.addChildResource(CacheContainerResourceDefinition.WILDCARD_PATH);
    }

    @Override
    public void accept(ModelVersion version) {
        if (InfinispanSubsystemModel.VERSION_16_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

                protected void convertAttribute(PathAddress address, String name, ModelNode modules, TransformationContext context) {
                    if (modules.isDefined()) {
                        for (ModelNode module : modules.asList()) {
                            if (!SERVER_MODULES.contains(module.asString())) continue;
                            module.set(CacheContainerResourceTransformer.LEGACY_SERVER_MODULE);
                        }
                    }
                }
            }, new AttributeDefinition[]{CacheContainerResourceDefinition.ListAttribute.MODULES.getDefinition()})).end();
        }
        if (InfinispanSubsystemModel.VERSION_15_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)this.builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{CacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition()})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleAcceptAttributeChecker(CacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition().getDefaultValue()), new AttributeDefinition[]{CacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition()})).end();
        }
        new ScatteredCacheResourceTransformer(this.builder).accept(version);
        new DistributedCacheResourceTransformer(this.builder).accept(version);
        new ReplicatedCacheResourceTransformer(this.builder).accept(version);
        new InvalidationCacheResourceTransformer(this.builder).accept(version);
        new LocalCacheResourceTransformer(this.builder).accept(version);
    }
}

