/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.IOException;
import java.util.Map;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemSchema;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemInitialization;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.IntVersion;
import org.wildfly.clustering.service.UnaryRequirement;

public class OperationTestCaseBase
extends AbstractSubsystemTest {
    static final String SUBSYSTEM_XML_FILE = String.format("infinispan-%d.%d.xml", ((IntVersion)InfinispanSubsystemSchema.CURRENT.getVersion()).major(), ((IntVersion)InfinispanSubsystemSchema.CURRENT.getVersion()).minor());

    public OperationTestCaseBase() {
        super("infinispan", (Extension)new InfinispanExtension());
    }

    KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder(this.createAdditionalInitialization());
    }

    AdditionalInitialization createAdditionalInitialization() {
        return new JGroupsSubsystemInitialization().require((UnaryRequirement)CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING, new String[]{"hotrod-server-1", "hotrod-server-2"}).require((UnaryRequirement)CommonUnaryRequirement.DATA_SOURCE, new String[]{"ExampleDS", "new-datasource"});
    }

    protected static ModelNode getCacheContainerAddOperation(String containerName) {
        PathAddress address = OperationTestCaseBase.getCacheContainerAddress(containerName);
        return Util.createAddOperation((PathAddress)address, Map.of(CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.getName(), new ModelNode("default")));
    }

    protected static ModelNode getCacheContainerReadOperation(String containerName, Attribute attribute) {
        return Util.getReadAttributeOperation((PathAddress)OperationTestCaseBase.getCacheContainerAddress(containerName), (String)attribute.getName());
    }

    protected static ModelNode getCacheContainerWriteOperation(String containerName, Attribute attribute, String value) {
        PathAddress cacheAddress = OperationTestCaseBase.getCacheContainerAddress(containerName);
        return Util.getWriteAttributeOperation((PathAddress)cacheAddress, (String)attribute.getName(), (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getCacheContainerRemoveOperation(String containerName) {
        PathAddress containerAddr = OperationTestCaseBase.getCacheContainerAddress(containerName);
        return Util.createRemoveOperation((PathAddress)containerAddr);
    }

    protected static ModelNode getCacheAddOperation(String containerName, String cacheType, String cacheName) {
        PathAddress address = OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName);
        return Util.createAddOperation((PathAddress)address, Map.of());
    }

    protected static ModelNode getCacheReadOperation(String containerName, String cacheType, String cacheName, Attribute attribute) {
        return Util.getReadAttributeOperation((PathAddress)OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName), (String)attribute.getName());
    }

    protected static ModelNode getCacheWriteOperation(String containerName, String cacheType, String cacheName, Attribute attribute, String value) {
        return Util.getWriteAttributeOperation((PathAddress)OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName), (String)attribute.getName(), (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getCacheRemoveOperation(String containerName, String cacheType, String cacheName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName));
    }

    protected static ModelNode getCacheStoreReadOperation(String containerName, String cacheType, String cacheName, Attribute attribute) {
        return Util.getReadAttributeOperation((PathAddress)OperationTestCaseBase.getCustomCacheStoreAddress(containerName, cacheType, cacheName), (String)attribute.getName());
    }

    protected static ModelNode getCacheStoreWriteOperation(String containerName, String cacheName, String cacheType, Attribute attribute, String value) {
        return Util.getWriteAttributeOperation((PathAddress)OperationTestCaseBase.getCustomCacheStoreAddress(containerName, cacheType, cacheName), (String)attribute.getName(), (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getJDBCCacheStoreReadOperation(String containerName, String cacheType, String cacheName, Attribute attribute) {
        return Util.getReadAttributeOperation((PathAddress)OperationTestCaseBase.getJDBCCacheStoreAddress(containerName, cacheType, cacheName), (String)attribute.getName());
    }

    protected static ModelNode getJDBCCacheStoreWriteOperation(String containerName, String cacheType, String cacheName, Attribute attribute, String value) {
        return Util.getWriteAttributeOperation((PathAddress)OperationTestCaseBase.getJDBCCacheStoreAddress(containerName, cacheType, cacheName), (String)attribute.getName(), (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getCacheStoreGetPropertyOperation(PathAddress cacheStoreAddress, String propertyName) {
        return Util.createMapGetOperation((PathAddress)cacheStoreAddress, (String)StoreResourceDefinition.Attribute.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getCacheStorePutPropertyOperation(PathAddress cacheStoreAddress, String propertyName, String propertyValue) {
        return Util.createMapPutOperation((PathAddress)cacheStoreAddress, (String)StoreResourceDefinition.Attribute.PROPERTIES.getName(), (String)propertyName, (String)propertyValue);
    }

    protected static ModelNode getCacheStoreRemovePropertyOperation(PathAddress cacheStoreAddress, String propertyName) {
        return Util.createMapRemoveOperation((PathAddress)cacheStoreAddress, (String)StoreResourceDefinition.Attribute.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getCacheStoreClearPropertiesOperation(PathAddress cacheStoreAddress) {
        return Util.createMapClearOperation((PathAddress)cacheStoreAddress, (String)StoreResourceDefinition.Attribute.PROPERTIES.getName());
    }

    protected static ModelNode getCacheStoreUndefinePropertiesOperation(PathAddress cacheStoreAddress) {
        return Util.getUndefineAttributeOperation((PathAddress)cacheStoreAddress, (String)StoreResourceDefinition.Attribute.PROPERTIES.getName());
    }

    protected static PathAddress getJDBCCacheStoreAddress(String containerName, String cacheType, String cacheName) {
        return OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName).append(new PathElement[]{JDBCStoreResourceDefinition.PATH});
    }

    protected static PathAddress getRemoteCacheStoreAddress(String containerName, String cacheType, String cacheName) {
        return OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName).append(new PathElement[]{RemoteStoreResourceDefinition.PATH});
    }

    protected static PathAddress getFileCacheStoreAddress(String containerName, String cacheType, String cacheName) {
        return OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName).append(new PathElement[]{FileStoreResourceDefinition.PATH});
    }

    protected static PathAddress getCustomCacheStoreAddress(String containerName, String cacheType, String cacheName) {
        return OperationTestCaseBase.getCacheAddress(containerName, cacheType, cacheName).append(new PathElement[]{CustomStoreResourceDefinition.PATH});
    }

    protected static PathAddress getCacheContainerAddress(String containerName) {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanSubsystemResourceDefinition.PATH}).append(new PathElement[]{CacheContainerResourceDefinition.pathElement((String)containerName)});
    }

    protected static PathAddress getCacheAddress(String containerName, String cacheType, String cacheName) {
        return OperationTestCaseBase.getCacheContainerAddress(containerName).append(cacheType, cacheName);
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource(SUBSYSTEM_XML_FILE);
    }
}

