/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.Properties;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemInitialization;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemSchema;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.subsystem.test.AbstractSubsystemSchemaTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

@RunWith(value=Parameterized.class)
public class InfinispanSubsystemTestCase
extends AbstractSubsystemSchemaTest<InfinispanSubsystemSchema> {
    private final InfinispanSubsystemSchema schema;

    @Parameterized.Parameters
    public static Iterable<InfinispanSubsystemSchema> parameters() {
        return EnumSet.allOf(InfinispanSubsystemSchema.class);
    }

    public InfinispanSubsystemTestCase(InfinispanSubsystemSchema schema) {
        super("infinispan", (Extension)new InfinispanExtension(), (SubsystemSchema)schema, (SubsystemSchema)InfinispanSubsystemSchema.CURRENT);
        this.schema = schema;
    }

    protected String getSubsystemXsdPathPattern() {
        return "schema/jboss-as-%s_%d_%d.xsd";
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new InfinispanSubsystemInitialization().require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "hotrod-server-1").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "hotrod-server-2").require(CommonServiceDescriptor.DATA_SOURCE, "ExampleDS").require(PathManager.PATH_SERVICE_DESCRIPTOR, "jboss.server.temp.dir").require(ChannelFactory.DEFAULT_SERVICE_DESCRIPTOR).require(TransactionResourceDefinition.LOCAL_TRANSACTION_PROVIDER).require(TransactionResourceDefinition.XA_RESOURCE_RECOVERY_REGISTRY);
    }

    protected void compare(ModelNode model1, ModelNode model2) {
        InfinispanSubsystemTestCase.purgeJGroupsModel(model1);
        InfinispanSubsystemTestCase.purgeJGroupsModel(model2);
        super.compare(model1, model2);
    }

    private static void purgeJGroupsModel(ModelNode model) {
        model.get(JGroupsSubsystemResourceDefinition.PATH.getKey()).remove(JGroupsSubsystemResourceDefinition.PATH.getValue());
    }

    protected Properties getResolvedProperties() {
        Properties properties = new Properties();
        properties.put("java.io.tmpdir", "/tmp");
        return properties;
    }

    protected KernelServices standardSubsystemTest(String configId, String configIdResolvedModel, boolean compareXml, AdditionalInitialization additionalInit) throws Exception {
        KernelServices services = super.standardSubsystemTest(configId, configIdResolvedModel, compareXml, additionalInit);
        if (!this.schema.since((VersionedFeature)InfinispanSubsystemSchema.VERSION_1_5)) {
            ModelNode model = services.readWholeModel();
            Assert.assertTrue((boolean)model.get(InfinispanSubsystemResourceDefinition.PATH.getKey()).hasDefined(InfinispanSubsystemResourceDefinition.PATH.getValue()));
            ModelNode subsystem = model.get(InfinispanSubsystemResourceDefinition.PATH.getKeyValuePair());
            for (Property containerProp : subsystem.get(CacheContainerResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                Assert.assertTrue((String)("cache-container=" + containerProp.getName()), (boolean)containerProp.getValue().get(CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.getName()).asBoolean());
                for (String key : containerProp.getValue().keys()) {
                    ModelNode caches;
                    if (!key.endsWith("-cache") || key.equals("default-cache") || !(caches = containerProp.getValue().get(key)).isDefined()) continue;
                    for (Property cacheProp : caches.asPropertyList()) {
                        Assert.assertTrue((String)("cache-container=" + containerProp.getName() + "," + key + "=" + cacheProp.getName()), (boolean)containerProp.getValue().get(CacheResourceDefinition.Attribute.STATISTICS_ENABLED.getName()).asBoolean());
                    }
                }
            }
        }
        return services;
    }
}

