/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.HeapMemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemInitialization;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScatteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemInitialization;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelFixer;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jgroups.conf.ClassConfigurator;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class InfinispanTransformersTestCase
extends OperationTestCaseBase {
    private static String formatArtifact(String pattern, ModelTestControllerVersion version) {
        return String.format(pattern, version.getMavenGavVersion());
    }

    private static InfinispanSubsystemModel getModelVersion(ModelTestControllerVersion controllerVersion) {
        switch (controllerVersion) {
            case EAP_7_4_0: {
                return InfinispanSubsystemModel.VERSION_14_0_0;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String[] getDependencies(ModelTestControllerVersion version) {
        switch (version) {
            case EAP_7_4_0: {
                return new String[]{"org.jboss.spec.javax.transaction:jboss-transaction-api_1.3_spec:2.0.0.Final", "org.jboss.spec.javax.resource:jboss-connector-api_1.7_spec:2.0.0.Final", InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-infinispan-extension:%s", version), "org.infinispan:infinispan-commons:11.0.9.Final-redhat-00001", "org.infinispan:infinispan-core:11.0.9.Final-redhat-00001", "org.infinispan:infinispan-cachestore-jdbc:11.0.9.Final-redhat-00001", "org.infinispan:infinispan-client-hotrod:11.0.9.Final-redhat-00001", "org.jboss.spec.javax.resource:jboss-connector-api_1.7_spec:2.0.0.Final-redhat-00001", InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-api:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-common:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-infinispan-client:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-infinispan-spi:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-jgroups-extension:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-jgroups-spi:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-server:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-service:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-singleton-api:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-clustering-spi:%s", version), InfinispanTransformersTestCase.formatArtifact("org.jboss.eap:wildfly-connector:%s", version)};
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    AdditionalInitialization createAdditionalInitialization() {
        return new InfinispanSubsystemInitialization().require(PathManager.SERVICE_DESCRIPTOR).require(PathManager.PATH_SERVICE_DESCRIPTOR, "jboss.server.temp.dir").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "hotrod-server-1").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "hotrod-server-2").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "jdg1").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "jdg2").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "jdg3").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "jdg4").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "jdg5").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "jdg6").require(CommonServiceDescriptor.DATA_SOURCE, "ExampleDS").require(CommonServiceDescriptor.SSL_CONTEXT, "hotrod-elytron").require(ChannelFactory.SERVICE_DESCRIPTOR, "maximal-channel").require(ChannelFactory.DEFAULT_SERVICE_DESCRIPTOR).require(TransactionResourceDefinition.LOCAL_TRANSACTION_PROVIDER).require(TransactionResourceDefinition.XA_RESOURCE_RECOVERY_REGISTRY);
    }

    @Test
    public void testTransformerEAP740() throws Exception {
        this.testTransformation(ModelTestControllerVersion.EAP_7_4_0);
    }

    private KernelServices buildKernelServices(String xml, ModelTestControllerVersion controllerVersion, ModelVersion version, String ... mavenResourceURLs) throws Exception {
        KernelServicesBuilder builder = this.createKernelServicesBuilder().setSubsystemXml(xml);
        builder.createLegacyKernelServicesBuilder(this.createAdditionalInitialization(), controllerVersion, version).addMavenResourceURL(mavenResourceURLs).addSingleChildFirstClass(new Class[]{InfinispanSubsystemInitialization.class}).addSingleChildFirstClass(new Class[]{JGroupsSubsystemInitialization.class}).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addSingleChildFirstClass(new Class[]{ClassConfigurator.class}).skipReverseControllerCheck().dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((String)(ModelTestControllerVersion.MASTER + " boot failed"), (boolean)services.isSuccessfulBoot());
        Assert.assertTrue((String)(controllerVersion.getMavenGavVersion() + " boot failed"), (boolean)((KernelServices)services.getLegacyServices(version)).isSuccessfulBoot());
        return services;
    }

    private void testTransformation(ModelTestControllerVersion controller) throws Exception {
        ModelVersion version = InfinispanTransformersTestCase.getModelVersion(controller).getVersion();
        String[] dependencies = InfinispanTransformersTestCase.getDependencies(controller);
        String subsystemXmlResource = String.format("subsystem-infinispan-transform-%d_%d_%d.xml", version.getMajor(), version.getMinor(), version.getMicro());
        KernelServices services = this.buildKernelServices(this.readResource(subsystemXmlResource), controller, version, dependencies);
        this.checkSubsystemModelTransformation(services, version, InfinispanTransformersTestCase.createModelFixer(version), false);
        ModelNode legacyModel = services.readTransformedModel(version);
        if (InfinispanSubsystemModel.VERSION_18_0_0.requiresTransformation(version)) {
            List modules;
            ModelNode subsystemModel = legacyModel.get(InfinispanSubsystemResourceDefinition.PATH.getKeyValuePair());
            for (Property property : subsystemModel.get(CacheContainerResourceDefinition.WILDCARD_PATH.getKey()).asPropertyListOrEmpty()) {
                modules = property.getValue().get(CacheContainerResourceDefinition.ListAttribute.MODULES.getName()).asListOrEmpty();
                Assert.assertTrue((boolean)modules.stream().map(ModelNode::asString).noneMatch("org.wildfly.clustering.session.infinispan.embedded"::equals));
            }
            for (Property property : subsystemModel.get(RemoteCacheContainerResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                modules = property.getValue().get(RemoteCacheContainerResourceDefinition.ListAttribute.MODULES.getName()).asListOrEmpty();
                Assert.assertTrue((boolean)modules.stream().map(ModelNode::asString).noneMatch("org.wildfly.clustering.session.infinispan.remote"::equals));
            }
        }
    }

    private static ModelFixer createModelFixer(ModelVersion version) {
        return model -> {
            if (InfinispanSubsystemModel.VERSION_16_0_0.requiresTransformation(version)) {
                Map containers = Map.ofEntries(Map.entry("minimal", List.of(DistributedCacheResourceDefinition.pathElement((String)"dist"))), Map.entry("maximal", List.of(DistributedCacheResourceDefinition.pathElement((String)"dist"), LocalCacheResourceDefinition.pathElement((String)"local"), ReplicatedCacheResourceDefinition.pathElement((String)"cache-with-jdbc-store"), ScatteredCacheResourceDefinition.pathElement((String)"scattered"))));
                for (Map.Entry entry : containers.entrySet()) {
                    PathElement containerPath = CacheContainerResourceDefinition.pathElement((String)((String)entry.getKey()));
                    ModelNode containerModel = model.get(containerPath.getKeyValuePair());
                    containerModel.get("module").set(new ModelNode());
                    for (PathElement cachePath : (List)entry.getValue()) {
                        ModelNode cacheModel = containerModel.get(cachePath.getKey()).get(cachePath.getValue());
                        cacheModel.get("module").set(new ModelNode());
                        if (cacheModel.hasDefined(HeapMemoryResourceDefinition.PATH.getKeyValuePair())) {
                            ModelNode memoryModel = cacheModel.get(HeapMemoryResourceDefinition.PATH.getKeyValuePair());
                            memoryModel.get("max-entries").set(new ModelNode());
                        }
                        if (!cacheModel.hasDefined(JDBCStoreResourceDefinition.PATH.getKeyValuePair())) continue;
                        ModelNode storeModel = cacheModel.get(JDBCStoreResourceDefinition.PATH.getKeyValuePair());
                        storeModel.get("datasource").set(new ModelNode());
                        if (!storeModel.hasDefined(StringTableResourceDefinition.PATH.getKeyValuePair())) continue;
                        ModelNode tableModel = storeModel.get(StringTableResourceDefinition.PATH.getKeyValuePair());
                        tableModel.get("batch-size").set(new ModelNode());
                    }
                    for (ScheduledThreadPoolResourceDefinition pool : EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class)) {
                        if (!containerModel.hasDefined(pool.getPathElement().getKeyValuePair())) continue;
                        ModelNode poolModel = containerModel.get(pool.getPathElement().getKeyValuePair());
                        poolModel.get("max-threads").set(new ModelNode());
                    }
                }
            }
            return model;
        };
    }

    @Test
    public void testRejectionsEAP740() throws Exception {
        this.testRejections(ModelTestControllerVersion.EAP_7_4_0);
    }

    private void testRejections(ModelTestControllerVersion controller) throws Exception {
        ModelVersion version = InfinispanTransformersTestCase.getModelVersion(controller).getVersion();
        String[] dependencies = InfinispanTransformersTestCase.getDependencies(controller);
        KernelServicesBuilder builder = this.createKernelServicesBuilder();
        builder.createLegacyKernelServicesBuilder(this.createAdditionalInitialization(), controller, version).addSingleChildFirstClass(new Class[]{InfinispanSubsystemInitialization.class}).addSingleChildFirstClass(new Class[]{JGroupsSubsystemInitialization.class}).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addSingleChildFirstClass(new Class[]{ClassConfigurator.class}).addMavenResourceURL(dependencies).dontPersistXml();
        KernelServices services = builder.build();
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((String)"main services did not boot", (boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List operations = builder.parseXmlResource("subsystem-infinispan-transformer-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)version, (List)operations, (FailedOperationTransformationConfig)InfinispanTransformersTestCase.createFailedOperationConfig(version));
    }

    private static FailedOperationTransformationConfig createFailedOperationConfig(ModelVersion version) {
        FailedOperationTransformationConfig config = new FailedOperationTransformationConfig();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanSubsystemResourceDefinition.PATH});
        PathAddress containerAddress = subsystemAddress.append(new PathElement[]{CacheContainerResourceDefinition.WILDCARD_PATH});
        PathAddress remoteContainerAddress = subsystemAddress.append(new PathElement[]{RemoteCacheContainerResourceDefinition.WILDCARD_PATH});
        LinkedList<String> rejectedRemoteContainerAttributes = new LinkedList<String>();
        if (InfinispanSubsystemModel.VERSION_16_0_0.requiresTransformation(version)) {
            config.addFailedAttribute(containerAddress.append(new PathElement[]{ReplicatedCacheResourceDefinition.pathElement((String)"repl"), PartitionHandlingResourceDefinition.PATH}), (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.NewAttributesConfig(new AttributeDefinition[]{PartitionHandlingResourceDefinition.Attribute.MERGE_POLICY.getDefinition()}));
            config.addFailedAttribute(containerAddress.append(new PathElement[]{DistributedCacheResourceDefinition.pathElement((String)"dist"), PartitionHandlingResourceDefinition.PATH}), (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.NewAttributesConfig(new AttributeDefinition[]{PartitionHandlingResourceDefinition.Attribute.WHEN_SPLIT.getDefinition()}));
        }
        if (InfinispanSubsystemModel.VERSION_15_0_0.requiresTransformation(version)) {
            config.addFailedAttribute(containerAddress, (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.NewAttributesConfig(new AttributeDefinition[]{CacheContainerResourceDefinition.Attribute.MARSHALLER.getDefinition()}));
            rejectedRemoteContainerAttributes.add(RemoteCacheContainerResourceDefinition.Attribute.MARSHALLER.getName());
        }
        if (InfinispanSubsystemModel.VERSION_14_0_0.requiresTransformation(version)) {
            rejectedRemoteContainerAttributes.add(RemoteCacheContainerResourceDefinition.ListAttribute.MODULES.getName());
        }
        if (!rejectedRemoteContainerAttributes.isEmpty()) {
            config.addFailedAttribute(remoteContainerAddress, (FailedOperationTransformationConfig.PathAddressConfig)new FailedOperationTransformationConfig.NewAttributesConfig(rejectedRemoteContainerAttributes.toArray(new String[rejectedRemoteContainerAttributes.size()])));
        }
        return config;
    }
}

