/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.InputStream;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class OperationsTestCase
extends OperationTestCaseBase {
    @Test
    public void testCacheContainerReadWriteOperation() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(subsystemXml).build();
        ModelNode result = servicesA.executeOperation(OperationsTestCase.getCacheContainerReadOperation("maximal", (Attribute)CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"local", (Object)result.get("result").asString());
        result = servicesA.executeOperation(OperationsTestCase.getCacheContainerWriteOperation("maximal", (Attribute)CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE, "new-default-cache"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = servicesA.executeOperation(OperationsTestCase.getCacheContainerReadOperation("maximal", (Attribute)CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-default-cache", (Object)result.get("result").asString());
    }

    @Test
    public void testLocalCacheReadWriteOperation() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(subsystemXml).build();
        ModelNode readOperation = OperationsTestCase.getCacheReadOperation("maximal", LocalCacheResourceDefinition.WILDCARD_PATH.getKey(), "local", (Attribute)CacheResourceDefinition.Attribute.STATISTICS_ENABLED);
        ModelNode result = servicesA.executeOperation(readOperation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertTrue((boolean)result.get("result").asBoolean());
        ModelNode writeOperation = OperationsTestCase.getCacheWriteOperation("maximal", LocalCacheResourceDefinition.WILDCARD_PATH.getKey(), "local", (Attribute)CacheResourceDefinition.Attribute.STATISTICS_ENABLED, "false");
        result = servicesA.executeOperation(writeOperation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = servicesA.executeOperation(readOperation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").asBoolean());
    }

    @Test
    public void testDistributedCacheJDBCStoreReadWriteOperation() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(subsystemXml).build();
        ModelNode result = servicesA.executeOperation(OperationsTestCase.getJDBCCacheStoreReadOperation("maximal", DistributedCacheResourceDefinition.WILDCARD_PATH.getKey(), "dist", (Attribute)JDBCStoreResourceDefinition.Attribute.DATA_SOURCE), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"ExampleDS", (Object)result.get("result").asString());
        result = servicesA.executeOperation(OperationsTestCase.getJDBCCacheStoreWriteOperation("maximal", DistributedCacheResourceDefinition.WILDCARD_PATH.getKey(), "dist", (Attribute)JDBCStoreResourceDefinition.Attribute.DATA_SOURCE, "new-datasource"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = servicesA.executeOperation(OperationsTestCase.getJDBCCacheStoreReadOperation("maximal", DistributedCacheResourceDefinition.WILDCARD_PATH.getKey(), "dist", (Attribute)JDBCStoreResourceDefinition.Attribute.DATA_SOURCE), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-datasource", (Object)result.get("result").asString());
    }

    @Test
    public void testStoreProperties() throws Exception {
        KernelServices services = this.createKernelServicesBuilder().setSubsystemXml(this.getSubsystemXml()).build();
        PathAddress address = OperationsTestCase.getRemoteCacheStoreAddress("maximal", InvalidationCacheResourceDefinition.WILDCARD_PATH.getKey(), "invalid");
        String key = "infinispan.client.hotrod.ping_on_startup";
        String value = "true";
        ModelNode operation = Util.createMapPutOperation((PathAddress)address, (String)StoreResourceDefinition.Attribute.PROPERTIES.getName(), (String)key, (String)value);
        ModelNode result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
        operation = Util.createMapGetOperation((PathAddress)address, (String)StoreResourceDefinition.Attribute.PROPERTIES.getName(), (String)key);
        result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)value, (Object)result.get("result").asString());
        operation = Util.createMapRemoveOperation((PathAddress)address, (String)StoreResourceDefinition.Attribute.PROPERTIES.getName(), (String)key);
        result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
        operation = Util.createMapGetOperation((PathAddress)address, (String)StoreResourceDefinition.Attribute.PROPERTIES.getName(), (String)key);
        result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
    }

    @Test
    public void testAliases() throws Exception {
        KernelServices services = this.createKernelServicesBuilder().setSubsystemXml(this.getSubsystemXml()).build();
        PathAddress address = OperationsTestCase.getCacheContainerAddress("minimal");
        String alias = "alias0";
        ModelNode operation = Util.createListAddOperation((PathAddress)address, (String)CacheContainerResourceDefinition.ListAttribute.ALIASES.getName(), (String)alias);
        ModelNode result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
        operation = Util.createListGetOperation((PathAddress)address, (String)CacheContainerResourceDefinition.ListAttribute.ALIASES.getName(), (int)0);
        result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)new ModelNode(alias), (Object)result.get("result"));
        operation = Util.createListRemoveOperation((PathAddress)address, (String)CacheContainerResourceDefinition.ListAttribute.ALIASES.getName(), (int)0);
        result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
        operation = Util.createListGetOperation((PathAddress)address, (String)CacheContainerResourceDefinition.ListAttribute.ALIASES.getName(), (int)0);
        result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
    }
}

