/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.UnaryOperator;
import org.infinispan.util.concurrent.locks.impl.DefaultLockManager;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum LockingMetric implements Metric<DefaultLockManager>,
UnaryOperator<SimpleAttributeDefinitionBuilder>
{
    CURRENT_CONCURRENCY_LEVEL("current-concurrency-level", ModelType.INT, AttributeAccess.Flag.GAUGE_METRIC){

        public ModelNode execute(DefaultLockManager manager) {
            return new ModelNode(manager.getConcurrencyLevel());
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return (SimpleAttributeDefinitionBuilder)builder.setDeprecated(InfinispanSubsystemModel.VERSION_17_0_0.getVersion());
        }
    }
    ,
    NUMBER_OF_LOCKS_AVAILABLE("number-of-locks-available", ModelType.INT, AttributeAccess.Flag.GAUGE_METRIC){

        public ModelNode execute(DefaultLockManager manager) {
            return new ModelNode(manager.getNumberOfLocksAvailable());
        }
    }
    ,
    NUMBER_OF_LOCKS_HELD("number-of-locks-held", ModelType.INT, AttributeAccess.Flag.GAUGE_METRIC){

        public ModelNode execute(DefaultLockManager manager) {
            return new ModelNode(manager.getNumberOfLocksHeld());
        }
    };

    private final AttributeDefinition definition;

    private LockingMetric(String name, ModelType type, AttributeAccess.Flag metricType) {
        this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setFlags(new AttributeAccess.Flag[]{metricType})).setStorageRuntime()).build();
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
        return builder;
    }
}

