/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.infinispan.subsystem.CacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheRemoveHandler;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheAddHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;

enum CacheType {
    LOCAL("local-cache", new LocalCacheAddHandler(), new CacheRemoveHandler()),
    DISTRIBUTED("distributed-cache", new DistributedCacheAddHandler(), LOCAL.getRemoveHandler()),
    REPLICATED("replicated-cache", new ReplicatedCacheAddHandler(), LOCAL.getRemoveHandler()),
    INVALIDATION("invalidation-cache", new InvalidationCacheAddHandler(), LOCAL.getRemoveHandler());

    private static final Map<String, CacheType> TYPES;
    private final String key;
    private final CacheAddHandler addHandler;
    private final CacheRemoveHandler removeHandler;

    static CacheType forName(String key) {
        return TYPES.get(key);
    }

    private CacheType(String key, CacheAddHandler addHandler, CacheRemoveHandler removeHandler) {
        this.key = key;
        this.addHandler = addHandler;
        this.removeHandler = removeHandler;
    }

    public ResourceDescriptionResolver getResourceDescriptionResolver() {
        return new InfinispanResourceDescriptionResolver(this.key);
    }

    public PathElement pathElement() {
        return this.pathElement("*");
    }

    public PathElement pathElement(String name) {
        return PathElement.pathElement((String)this.key, (String)name);
    }

    public CacheAddHandler getAddHandler() {
        return this.addHandler;
    }

    public CacheRemoveHandler getRemoveHandler() {
        return this.removeHandler;
    }

    public boolean hasSharedState() {
        return EnumSet.of(REPLICATED, DISTRIBUTED).contains((Object)this);
    }

    static {
        TYPES = new HashMap<String, CacheType>();
        for (CacheType type : CacheType.values()) {
            TYPES.put(type.key, type);
        }
    }
}

