/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import org.infinispan.commons.dataconversion.MediaType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.infinispan.marshalling.AbstractMarshaller;
import org.wildfly.clustering.infinispan.marshalling.jboss.JBossMarshallingVersion;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;

public class JBossMarshaller
extends AbstractMarshaller {
    private final ByteBufferMarshaller marshaller;

    public JBossMarshaller(Module module) {
        this(module.getModuleLoader(), module);
    }

    public JBossMarshaller(ModuleLoader loader, Module module) {
        this((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(JBossMarshallingVersion.class, (Enum)JBossMarshallingVersion.CURRENT, new AbstractMap.SimpleImmutableEntry<ModuleLoader, Module>(loader, module)), (ClassLoader)module.getClassLoader());
    }

    public JBossMarshaller(MarshallingConfigurationRepository repository, ClassLoader loader) {
        this.marshaller = new JBossByteBufferMarshaller(repository, loader);
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_JBOSS_MARSHALLING;
    }

    public boolean isMarshallable(Object object) {
        return this.marshaller.isMarshallable(object);
    }

    public void writeObject(Object object, OutputStream output) throws IOException {
        this.marshaller.writeTo(output, object);
    }

    public Object readObject(InputStream input) throws ClassNotFoundException, IOException {
        return this.marshaller.readFrom(input);
    }
}

