/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.service;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.CacheContainer;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SimpleDependency;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;

public class CacheBuilder<K, V>
implements CapabilityServiceBuilder<Cache<K, V>>,
Supplier<Cache<K, V>>,
Consumer<Cache<K, V>> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile ValueDependency<CacheContainer> container;
    private volatile Dependency configuration;

    public CacheBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public Cache<K, V> get() {
        Cache cache = ((CacheContainer)this.container.getValue()).getCache(this.cacheName);
        cache.start();
        return cache;
    }

    @Override
    public void accept(Cache<K, V> cache) {
        cache.stop();
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<Cache<K, V>> configure(CapabilityServiceSupport support) {
        this.container = new InjectedValueDependency(InfinispanRequirement.CONTAINER.getServiceName(support, this.containerName), CacheContainer.class);
        this.configuration = new SimpleDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, this.containerName, this.cacheName));
        return this;
    }

    public ServiceBuilder<Cache<K, V>> build(ServiceTarget target) {
        SuppliedValueService service = new SuppliedValueService(Function.identity(), (Supplier)this, (Consumer)this);
        ServiceBuilder builder = new AsynchronousServiceBuilder(this.getServiceName(), (Service)service).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
        return new CompositeDependency(new Dependency[]{this.configuration, this.container}).register(builder);
    }
}

