/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResource;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;

public class CacheConfigOperationHandlers {
    static final OperationStepHandler TRANSPORT_ADD = new CacheConfigAdd(TransportResourceDefinition.TRANSPORT_ATTRIBUTES);
    static final OperationStepHandler LOCKING_ADD = new CacheConfigAdd(LockingResource.LOCKING_ATTRIBUTES);
    static final OperationStepHandler TRANSACTION_ADD = new CacheConfigAdd(TransactionResourceDefinition.TRANSACTION_ATTRIBUTES);
    static final OperationStepHandler EVICTION_ADD = new CacheConfigAdd(EvictionResourceDefinition.EVICTION_ATTRIBUTES);
    static final OperationStepHandler EXPIRATION_ADD = new CacheConfigAdd(ExpirationResourceDefinition.EXPIRATION_ATTRIBUTES);
    static final OperationStepHandler STATE_TRANSFER_ADD = new CacheConfigAdd(StateTransferResourceDefinition.STATE_TRANSFER_ATTRIBUTES);
    static final OperationStepHandler STORE_ADD = new CacheStoreAdd();
    static final OperationStepHandler STORE_WRITE_BEHIND_ADD = new CacheConfigAdd(StoreWriteBehindResourceDefinition.WRITE_BEHIND_ATTRIBUTES);
    static final OperationStepHandler STORE_PROPERTY_ADD = new CacheConfigAdd(new AttributeDefinition[]{StorePropertyResourceDefinition.VALUE});
    static final OperationStepHandler FILE_STORE_ADD = new FileCacheStoreAdd();
    static final OperationStepHandler STRING_KEYED_JDBC_STORE_ADD = new StringKeyedJDBCCacheStoreAdd();
    static final OperationStepHandler BINARY_KEYED_JDBC_STORE_ADD = new BinaryKeyedJDBCCacheStoreAdd();
    static final OperationStepHandler MIXED_KEYED_JDBC_STORE_ADD = new MixedKeyedJDBCCacheStoreAdd();
    static final OperationStepHandler REMOTE_STORE_ADD = new RemoteCacheStoreAdd();

    private static PathAddress getCacheAddress(ModelNode operation) {
        PathAddress cacheStoreAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress cacheAddress = cacheStoreAddress.subAddress(0, cacheStoreAddress.size() - 1);
        return cacheAddress;
    }

    private static ModelNode getCache(OperationContext context, PathAddress cacheAddress) {
        ModelNode cache = Resource.Tools.readModel((Resource)context.readResourceFromRoot(cacheAddress));
        return cache;
    }

    private static boolean isCacheStoreDefined(OperationContext context, ModelNode operation) {
        ModelNode cache = CacheConfigOperationHandlers.getCache(context, CacheConfigOperationHandlers.getCacheAddress(operation));
        return CacheConfigOperationHandlers.hasCustomStore(cache) || CacheConfigOperationHandlers.hasFileStore(cache) || CacheConfigOperationHandlers.hasStringKeyedJdbcStore(cache) || CacheConfigOperationHandlers.hasBinaryKeyedJdbcStore(cache) || CacheConfigOperationHandlers.hasMixedKeyedJdbcStore(cache) || CacheConfigOperationHandlers.hasRemoteStore(cache);
    }

    private static String getDefinedCacheStore(OperationContext context, ModelNode operation) {
        ModelNode cache = CacheConfigOperationHandlers.getCache(context, CacheConfigOperationHandlers.getCacheAddress(operation));
        if (CacheConfigOperationHandlers.hasCustomStore(cache)) {
            return "store";
        }
        if (CacheConfigOperationHandlers.hasFileStore(cache)) {
            return "file-store";
        }
        if (CacheConfigOperationHandlers.hasStringKeyedJdbcStore(cache)) {
            return "string-keyed-jdbc-store";
        }
        if (CacheConfigOperationHandlers.hasBinaryKeyedJdbcStore(cache)) {
            return "binary-keyed-jdbc-store";
        }
        if (CacheConfigOperationHandlers.hasMixedKeyedJdbcStore(cache)) {
            return "mixed-keyed-jdbc-store";
        }
        if (CacheConfigOperationHandlers.hasRemoteStore(cache)) {
            return "remote-store";
        }
        return null;
    }

    private static boolean hasCustomStore(ModelNode cache) {
        return cache.hasDefined("store") && cache.get(new String[]{"store", "STORE"}).isDefined();
    }

    private static boolean hasFileStore(ModelNode cache) {
        return cache.hasDefined("file-store") && cache.get(new String[]{"file-store", "FILE_STORE"}).isDefined();
    }

    private static boolean hasStringKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("string-keyed-jdbc-store") && cache.get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasBinaryKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("binary-keyed-jdbc-store") && cache.get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasMixedKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("mixed-keyed-jdbc-store") && cache.get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasRemoteStore(ModelNode cache) {
        return cache.hasDefined("remote-store") && cache.get(new String[]{"remote-store", "REMOTE_STORE"}).isDefined();
    }

    private static class RemoteCacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = RemoteStoreResourceDefinition.REMOTE_STORE_ATTRIBUTES;

        RemoteCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class MixedKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = MixedKeyedJDBCStoreResourceDefinition.MIXED_KEYED_JDBC_STORE_ATTRIBUTES;

        MixedKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class BinaryKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = BinaryKeyedJDBCStoreResourceDefinition.BINARY_KEYED_JDBC_STORE_ATTRIBUTES;

        BinaryKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class StringKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = StringKeyedJDBCStoreResourceDefinition.STRING_KEYED_JDBC_STORE_ATTRIBUTES;

        StringKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class JDBCCacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = BaseJDBCStoreResourceDefinition.COMMON_JDBC_STORE_ATTRIBUTES;

        JDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class FileCacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = FileStoreResourceDefinition.FILE_STORE_ATTRIBUTES;

        FileCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class CacheStoreAdd
    extends AbstractCacheStoreAdd {
        private final AttributeDefinition[] attributes = StoreResourceDefinition.STORE_ATTRIBUTES;

        CacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    static abstract class AbstractCacheStoreAdd
    extends AbstractAddStepHandler {
        private final AttributeDefinition[] attributes = BaseStoreResourceDefinition.COMMON_STORE_PARAMETERS;

        AbstractCacheStoreAdd() {
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            if (CacheConfigOperationHandlers.isCacheStoreDefined(context, operation)) {
                String storeName = CacheConfigOperationHandlers.getDefinedCacheStore(context, operation);
                throw InfinispanMessages.MESSAGES.cacheStoreAlreadyDefined(storeName);
            }
            for (AttributeDefinition attribute : this.attributes) {
                if (attribute.getName().equals(BaseStoreResourceDefinition.PROPERTIES.getName())) continue;
                attribute.validateAndSet(operation, model);
            }
            this.populateSubclassModel(context, operation, model);
            if (operation.hasDefined("properties")) {
                for (Property property : operation.get("properties").asPropertyList()) {
                    Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                    ModelNode value = property.getValue();
                    if (!value.isDefined()) {
                        throw InfinispanMessages.MESSAGES.propertyValueNotDefined(property.getName());
                    }
                    StorePropertyResourceDefinition.VALUE.validateAndSet(value, param.getModel());
                }
            }
        }

        abstract void populateSubclassModel(OperationContext var1, ModelNode var2, ModelNode var3) throws OperationFailedException;

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        }
    }

    public static class CacheConfigAdd
    extends AbstractAddStepHandler {
        private final AttributeDefinition[] attributes;

        CacheConfigAdd(AttributeDefinition[] attributes) {
            this.attributes = attributes;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attr : this.attributes) {
                attr.validateAndSet(operation, model);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            super.performRuntime(context, operation, model, verificationHandler, newControllers);
            context.reloadRequired();
        }
    }
}

