/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.invoker;

import java.util.Collections;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;

public interface Evictor<K> {
    public void evict(K var1);

    public static class PreLockedEvictOperation<K, V>
    implements CacheInvoker.Operation<K, V, Boolean> {
        private final K key;

        public PreLockedEvictOperation(K key) {
            this.key = key;
        }

        @Override
        public Boolean invoke(Cache<K, V> cache) {
            try {
                cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LOCKING}).evict(this.key);
                return true;
            }
            catch (CacheException e) {
                InfinispanLogger.ROOT_LOGGER.debugf(e, "Failed to evict %s from %s.%s cache", this.key, cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName(), cache.getName());
                return false;
            }
        }
    }

    public static class EvictOperation<K, V>
    implements CacheInvoker.Operation<K, V, Boolean> {
        private final K key;
        private final CacheInvoker.Operation<K, V, Boolean> operation;

        public EvictOperation(K key) {
            this.key = key;
            this.operation = new PreLockedEvictOperation(key);
        }

        @Override
        public Boolean invoke(Cache<K, V> cache) {
            boolean locked = cache.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}).lock(Collections.singleton(this.key));
            return locked ? this.operation.invoke(cache) : locked;
        }
    }
}

