/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;

public class CacheConfigurationService
extends AbstractCacheConfigurationService {
    private final ConfigurationBuilder builder;
    private final ModuleIdentifier moduleId;
    private final Dependencies dependencies;

    public static ServiceName getServiceName(String container, String cache) {
        return CacheService.getServiceName(container, cache).append(new String[]{"config"});
    }

    public CacheConfigurationService(String name, ConfigurationBuilder builder, ModuleIdentifier moduleId, Dependencies dependencies) {
        super(name);
        this.builder = builder;
        this.moduleId = moduleId;
        this.dependencies = dependencies;
    }

    @Override
    protected EmbeddedCacheManager getCacheContainer() {
        return this.dependencies.getCacheContainer();
    }

    @Override
    protected ConfigurationBuilder getConfigurationBuilder() {
        TransactionSynchronizationRegistry tsr;
        if (this.moduleId != null) {
            try {
                Module module = this.dependencies.getModuleLoader().loadModule(this.moduleId);
                ModuleClassLoader loader = module.getClassLoader();
                this.builder.classLoader((ClassLoader)loader);
                GroupsConfigurationBuilder groupsBuilder = this.builder.clustering().hash().groups();
                for (Grouper grouper : ServiceLoader.load(Grouper.class, (ClassLoader)loader)) {
                    groupsBuilder.addGrouper(grouper);
                }
            }
            catch (ModuleLoadException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.builder.jmxStatistics().enabled(this.dependencies.getCacheContainer().getCacheManagerConfiguration().globalJmxStatistics().enabled());
        TransactionManager tm = this.dependencies.getTransactionManager();
        if (tm != null) {
            this.builder.transaction().transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider(tm));
        }
        if ((tsr = this.dependencies.getTransactionSynchronizationRegistry()) != null) {
            this.builder.transaction().transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider(tsr));
        }
        return this.builder;
    }

    static interface Dependencies {
        public ModuleLoader getModuleLoader();

        public EmbeddedCacheManager getCacheContainer();

        public TransactionManager getTransactionManager();

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry();
    }
}

