/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.BackupForResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public abstract class SharedStateCacheAdd
extends ClusteredCacheAdd {
    SharedStateCacheAdd(CacheMode mode) {
        super(mode);
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, CacheAdd.CacheConfigurationDependencies cacheConfigurationDependencies, CacheAdd.CacheDependencies cacheDependencies, List<CacheAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, cache, builder, cacheConfigurationDependencies, cacheDependencies, dependencies);
        if (cache.hasDefined("state-transfer") && cache.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined()) {
            ModelNode stateTransfer = cache.get(new String[]{"state-transfer", "STATE_TRANSFER"});
            boolean enabled = StateTransferResourceDefinition.ENABLED.resolveModelAttribute(context, stateTransfer).asBoolean();
            long timeout = StateTransferResourceDefinition.TIMEOUT.resolveModelAttribute(context, stateTransfer).asLong();
            int chunkSize = StateTransferResourceDefinition.CHUNK_SIZE.resolveModelAttribute(context, stateTransfer).asInt();
            builder.clustering().stateTransfer().fetchInMemoryState(enabled);
            builder.clustering().stateTransfer().timeout(timeout);
            builder.clustering().stateTransfer().chunkSize(chunkSize);
        }
        if (cache.hasDefined("backup")) {
            SitesConfigurationBuilder sitesBuilder = builder.sites();
            for (Property property : cache.get("backup").asPropertyList()) {
                String siteName = property.getName();
                ModelNode site = property.getValue();
                sitesBuilder.addBackup().site(siteName).backupFailurePolicy(BackupFailurePolicy.valueOf((String)BackupSiteResourceDefinition.FAILURE_POLICY.resolveModelAttribute(context, site).asString())).strategy(BackupConfiguration.BackupStrategy.valueOf((String)BackupSiteResourceDefinition.STRATEGY.resolveModelAttribute(context, site).asString())).replicationTimeout(BackupSiteResourceDefinition.REPLICATION_TIMEOUT.resolveModelAttribute(context, site).asLong());
                if (!BackupSiteResourceDefinition.ENABLED.resolveModelAttribute(context, site).asBoolean()) continue;
                sitesBuilder.addInUseBackupSite(siteName);
            }
        }
        if (cache.hasDefined("backup-for") && cache.get(new String[]{"backup-for", "BACKUP_FOR"}).isDefined()) {
            ModelNode backupFor = cache.get(new String[]{"backup-for", "BACKUP_FOR"});
            ModelNode resolvedValue = null;
            resolvedValue = BackupForResourceDefinition.REMOTE_CACHE.resolveModelAttribute(context, backupFor);
            String remoteCache = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            resolvedValue = BackupForResourceDefinition.REMOTE_SITE.resolveModelAttribute(context, backupFor);
            String remoteSite = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            SitesConfigurationBuilder sitesBuilder = builder.sites();
            sitesBuilder.backupFor().remoteCache(remoteCache).remoteSite(remoteSite);
        }
    }
}

