/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;

public class InfinispanResourceDescriptionResolver
extends StandardResourceDescriptionResolver {
    private Map<String, String> sharedAttributeResolver = new HashMap<String, String>();

    public InfinispanResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader) {
        super(keyPrefix, bundleBaseName, bundleLoader, true, false);
        this.initMap();
    }

    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle2.getString(this.getBundleKey(attributeName));
        }
        return super.getResourceAttributeDescription(attributeName, locale, bundle2);
    }

    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle2.getString(this.getVariableBundleKey(attributeName, suffixes));
        }
        return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle2, suffixes);
    }

    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle2.getString(this.getBundleKey(paramName));
        }
        return super.getOperationParameterDescription(operationName, paramName, locale, bundle2);
    }

    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle2.getString(this.getVariableBundleKey(paramName, suffixes));
        }
        return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle2, suffixes);
    }

    public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(childType)) {
            return bundle2.getString(this.getBundleKey(childType));
        }
        return super.getChildTypeDescription(childType, locale, bundle2);
    }

    private String getBundleKey(String name) {
        return this.getVariableBundleKey(name, new String[0]);
    }

    private String getVariableBundleKey(String name, String ... variable) {
        String prefix = this.sharedAttributeResolver.get(name);
        StringBuilder sb = new StringBuilder("infinispan");
        sb = prefix == null ? sb.append('.').append(name) : sb.append('.').append(prefix).append('.').append(name);
        if (variable != null) {
            for (String arg : variable) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(arg);
            }
        }
        return sb.toString();
    }

    private void initMap() {
        this.sharedAttributeResolver.put(CacheResourceDefinition.BATCHING.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.MODULE.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.INDEXING.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.INDEXING_PROPERTIES.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.JNDI_NAME.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.NAME.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.START.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.STATISTICS_ENABLED.getName(), "cache");
        this.sharedAttributeResolver.put(ClusteredCacheResourceDefinition.ASYNC_MARSHALLING.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResourceDefinition.MODE.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResourceDefinition.QUEUE_FLUSH_INTERVAL.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResourceDefinition.QUEUE_SIZE.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResourceDefinition.REMOTE_TIMEOUT.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(StoreResourceDefinition.FETCH_STATE.getName(), "store");
        this.sharedAttributeResolver.put(StoreResourceDefinition.PASSIVATION.getName(), "store");
        this.sharedAttributeResolver.put(StoreResourceDefinition.PRELOAD.getName(), "store");
        this.sharedAttributeResolver.put(StoreResourceDefinition.PURGE.getName(), "store");
        this.sharedAttributeResolver.put(StoreResourceDefinition.SHARED.getName(), "store");
        this.sharedAttributeResolver.put(StoreResourceDefinition.SINGLETON.getName(), "store");
        this.sharedAttributeResolver.put(StoreResourceDefinition.PROPERTY.getName(), "store");
        this.sharedAttributeResolver.put(StoreResourceDefinition.PROPERTIES.getName(), "store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.DATA_SOURCE.getName(), "jdbc-store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.DIALECT.getName(), "jdbc-store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.BATCH_SIZE.getName(), "jdbc-store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.FETCH_SIZE.getName(), "jdbc-store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.PREFIX.getName(), "jdbc-store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.ID_COLUMN.getName() + ".column", "jdbc-store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.DATA_COLUMN.getName() + ".column", "jdbc-store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.TIMESTAMP_COLUMN.getName() + ".column", "jdbc-store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.ENTRY_TABLE.getName() + "table", "jdbc-store");
        this.sharedAttributeResolver.put(JDBCStoreResourceDefinition.BUCKET_TABLE.getName() + "table", "jdbc-store");
        this.sharedAttributeResolver.put(CacheResourceDefinition.ACTIVATIONS.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.AVERAGE_READ_TIME.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.AVERAGE_WRITE_TIME.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.CACHE_STATUS.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.ELAPSED_TIME.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.HIT_RATIO.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.HITS.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.INVALIDATIONS.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.MISSES.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.NUMBER_OF_ENTRIES.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.PASSIVATIONS.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.READ_WRITE_RATIO.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.REMOVE_HITS.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.REMOVE_MISSES.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.STORES.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResourceDefinition.TIME_SINCE_RESET.getName(), "cache");
        this.sharedAttributeResolver.put(ClusteredCacheResourceDefinition.AVERAGE_REPLICATION_TIME.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResourceDefinition.REPLICATION_COUNT.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResourceDefinition.REPLICATION_FAILURES.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResourceDefinition.SUCCESS_RATIO.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(StoreResourceDefinition.CACHE_LOADER_LOADS.getName(), "store");
        this.sharedAttributeResolver.put(StoreResourceDefinition.CACHE_LOADER_MISSES.getName(), "store");
        this.sharedAttributeResolver.put("transport", null);
        this.sharedAttributeResolver.put("locking", null);
        this.sharedAttributeResolver.put("transaction", null);
        this.sharedAttributeResolver.put("eviction", null);
        this.sharedAttributeResolver.put("expiration", null);
        this.sharedAttributeResolver.put("state-transfer", null);
        this.sharedAttributeResolver.put("store", null);
        this.sharedAttributeResolver.put("file-store", null);
        this.sharedAttributeResolver.put("remote-store", null);
        this.sharedAttributeResolver.put("string-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("binary-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("mixed-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("write-behind", null);
        this.sharedAttributeResolver.put("property", null);
        this.sharedAttributeResolver.put("backup-for", null);
    }
}

