/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.jboss.as.clustering.infinispan.CacheContainer;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentRegistryService;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelInstanceResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.server.Services;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;
import org.wildfly.clustering.spi.ClusterServiceInstaller;
import org.wildfly.clustering.spi.LocalServiceInstaller;
import org.wildfly.clustering.spi.ServiceInstaller;

public class CacheContainerAddHandler
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheContainerAddHandler.class.getPackage().getName());

    static ModelNode createOperation(ModelNode address, ModelNode existing) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAddHandler.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        CacheContainerResourceDefinition.DEFAULT_CACHE.validateAndSet(source, target);
        if (source.hasDefined("aliases")) {
            target.get("aliases").set(source.get("aliases"));
        }
        CacheContainerResourceDefinition.JNDI_NAME.validateAndSet(source, target);
        CacheContainerResourceDefinition.START.validateAndSet(source, target);
        CacheContainerResourceDefinition.LISTENER_EXECUTOR.validateAndSet(source, target);
        CacheContainerResourceDefinition.EVICTION_EXECUTOR.validateAndSet(source, target);
        CacheContainerResourceDefinition.REPLICATION_QUEUE_EXECUTOR.validateAndSet(source, target);
        CacheContainerResourceDefinition.MODULE.validateAndSet(source, target);
        CacheContainerResourceDefinition.STATISTICS_ENABLED.validateAndSet(source, target);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CacheContainerAddHandler.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode localModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        newControllers.addAll(CacheContainerAddHandler.installRuntimeServices(context, operation, model, verificationHandler));
    }

    static Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        boolean clustered;
        PathElement ejbPath;
        Resource rootResource;
        PathAddress address = CacheContainerAddHandler.getCacheContainerAddressFromOperation(operation);
        String name = address.getLastElement().getValue();
        if (context.getProcessType().isServer() && !context.isBooting() && name.equals("ejb") && (rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS)).hasChild(ejbPath = PathElement.pathElement((String)"subsystem", (String)"ejb3")) && rootResource.getChild(ejbPath).hasChild(PathElement.pathElement((String)"service", (String)"remote"))) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            return Collections.emptyList();
        }
        ServiceTarget target = context.getServiceTarget();
        ModelNode resolvedValue = null;
        resolvedValue = CacheContainerResourceDefinition.DEFAULT_CACHE.resolveModelAttribute(context, containerModel);
        String defaultCache = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResourceDefinition.JNDI_NAME.resolveModelAttribute(context, containerModel);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResourceDefinition.LISTENER_EXECUTOR.resolveModelAttribute(context, containerModel);
        String listenerExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResourceDefinition.EVICTION_EXECUTOR.resolveModelAttribute(context, containerModel);
        String evictionExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = CacheContainerResourceDefinition.REPLICATION_QUEUE_EXECUTOR.resolveModelAttribute(context, containerModel);
        String replicationQueueExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ServiceController.Mode initialMode = StartMode.valueOf(CacheContainerResourceDefinition.START.resolveModelAttribute(context, containerModel).asString()).getMode();
        boolean statistics = CacheContainerResourceDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, containerModel).asBoolean();
        ServiceName[] aliases = null;
        if (containerModel.hasDefined("aliases")) {
            List list = operation.get("aliases").asList();
            aliases = new ServiceName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
            }
        }
        ModuleIdentifier moduleId = (resolvedValue = CacheContainerResourceDefinition.MODULE.resolveModelAttribute(context, containerModel)).isDefined() ? ModuleIdentifier.fromString((String)resolvedValue.asString()) : null;
        Transport transportConfig = containerModel.hasDefined("transport") && containerModel.get("transport").hasDefined("TRANSPORT") ? new Transport() : null;
        String stack = null;
        String transportExecutor = null;
        LinkedList controllers = new LinkedList();
        boolean bl = clustered = transportConfig != null;
        if (clustered) {
            ModelNode transport = containerModel.get(new String[]{"transport", "TRANSPORT"});
            resolvedValue = TransportResourceDefinition.STACK.resolveModelAttribute(context, transport);
            if (resolvedValue.isDefined()) {
                stack = resolvedValue.asString();
            }
            String clusterName = name;
            resolvedValue = TransportResourceDefinition.CLUSTER.resolveModelAttribute(context, transport);
            if (resolvedValue.isDefined()) {
                clusterName = resolvedValue.asString();
            }
            long lockTimeout = TransportResourceDefinition.LOCK_TIMEOUT.resolveModelAttribute(context, transport).asLong();
            resolvedValue = TransportResourceDefinition.EXECUTOR.resolveModelAttribute(context, transport);
            if (resolvedValue.isDefined()) {
                transportExecutor = resolvedValue.asString();
            }
            transportConfig.setClusterName(clusterName);
            transportConfig.setLockTimeout(lockTimeout);
            controllers.addAll(CacheContainerAddHandler.installChannelServices(target, name, stack, verificationHandler));
            ChannelInstanceResourceDefinition.addChannelProtocolMetricsRegistrationStep((OperationContext)context, (String)clusterName, (String)stack);
            CacheContainerAddHandler.install(target, ClusterServiceInstaller.class, name, moduleId);
        } else {
            CacheContainerAddHandler.install(target, LocalServiceInstaller.class, name, moduleId);
        }
        controllers.add(CacheContainerAddHandler.installContainerConfigurationService(target, name, defaultCache, statistics, moduleId, stack, transportConfig, transportExecutor, listenerExecutor, evictionExecutor, replicationQueueExecutor, verificationHandler));
        controllers.add(CacheContainerAddHandler.installContainerService(target, name, aliases, transportConfig, initialMode, verificationHandler));
        controllers.add(CacheContainerAddHandler.installJndiService(target, name, jndiName, verificationHandler));
        controllers.add(CacheContainerAddHandler.installKeyAffinityServiceFactoryService(target, name, verificationHandler));
        controllers.add(CacheContainerAddHandler.installGlobalComponentRegistryService(target, name, transportConfig, verificationHandler));
        log.debugf("%s cache container installed", (Object)name);
        return controllers;
    }

    private static <I extends ServiceInstaller> void install(ServiceTarget target, Class<I> installerClass, String group, ModuleIdentifier moduleId) {
        for (ServiceInstaller installer : ServiceLoader.load(installerClass, installerClass.getClassLoader())) {
            log.debugf("Installing %s for channel %s", (Object)installer.getClass().getSimpleName(), (Object)group);
            installer.install(target, group, moduleId);
        }
    }

    static void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = CacheContainerAddHandler.getCacheContainerAddressFromOperation(operation);
        String containerName = address.getLastElement().getValue();
        context.removeService(KeyAffinityServiceFactoryService.getServiceName(containerName));
        ModelNode resolvedValue = null;
        resolvedValue = CacheContainerResourceDefinition.JNDI_NAME.resolveModelAttribute(context, model);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        context.removeService(CacheContainerAddHandler.createCacheContainerBinding(jndiName, containerName).getBinderServiceName());
        context.removeService(EmbeddedCacheManagerService.getServiceName(containerName));
        context.removeService(EmbeddedCacheManagerConfigurationService.getServiceName(containerName));
        context.removeService(GlobalComponentRegistryService.getServiceName(containerName));
        if (model.hasDefined("transport")) {
            CacheContainerAddHandler.removeServices(context, ClusterServiceInstaller.class, containerName);
            ChannelInstanceResourceDefinition.addChannelProtocolMetricsDeregistrationStep((OperationContext)context, (String)containerName);
            context.removeService(CacheContainerAddHandler.createChannelBinding(containerName).getBinderServiceName());
            context.removeService(ChannelService.getServiceName((String)containerName));
        } else {
            CacheContainerAddHandler.removeServices(context, LocalServiceInstaller.class, containerName);
        }
    }

    private static <I extends ServiceInstaller> void removeServices(OperationContext context, Class<I> installerClass, String group) {
        for (ServiceInstaller installer : ServiceLoader.load(installerClass, installerClass.getClassLoader())) {
            for (ServiceName name : installer.getServiceNames(group)) {
                context.removeService(name);
            }
        }
    }

    private static ServiceController<?> installGlobalComponentRegistryService(ServiceTarget target, String containerName, Transport transport, ServiceVerificationHandler verificationHandler) {
        InjectedValue container = new InjectedValue();
        ServiceBuilder builder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)GlobalComponentRegistryService.getServiceName(containerName), (Service)new GlobalComponentRegistryService((Value<CacheContainer>)container)).addDependency(EmbeddedCacheManagerService.getServiceName(containerName), CacheContainer.class, (Injector)container).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (transport != null) {
            builder.addDependency(ChannelService.getServiceName((String)containerName));
        }
        return builder.install();
    }

    private static ServiceController<?> installKeyAffinityServiceFactoryService(ServiceTarget target, String containerName, ServiceVerificationHandler verificationHandler) {
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)KeyAffinityServiceFactoryService.getServiceName(containerName), (Service)new KeyAffinityServiceFactoryService(10), (boolean)false, (boolean)true).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    private static Collection<ServiceController<?>> installChannelServices(ServiceTarget target, String containerName, String stack, ServiceVerificationHandler verificationHandler) {
        ContextNames.BindInfo bindInfo = CacheContainerAddHandler.createChannelBinding(containerName);
        ServiceName name = ChannelService.getServiceName((String)containerName);
        ServiceController binderService = new BinderServiceBuilder(target).build(bindInfo, name, Channel.class).install();
        ServiceController channelService = ChannelService.build((ServiceTarget)target, (String)containerName, (String)stack).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return Arrays.asList(binderService, channelService);
    }

    private static PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    private static ServiceController<?> installContainerConfigurationService(ServiceTarget target, String containerName, String defaultCache, boolean statistics, ModuleIdentifier moduleId, String stack, Transport transportConfig, String transportExecutor, String listenerExecutor, String evictionExecutor, String replicationQueueExecutor, ServiceVerificationHandler verificationHandler) {
        ServiceName configServiceName = EmbeddedCacheManagerConfigurationService.getServiceName(containerName);
        EmbeddedCacheManagerDependencies dependencies = new EmbeddedCacheManagerDependencies(transportConfig);
        EmbeddedCacheManagerConfigurationService service = new EmbeddedCacheManagerConfigurationService(containerName, defaultCache, statistics, moduleId, dependencies);
        ServiceBuilder configBuilder = target.addService(configServiceName, (Service)service).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, dependencies.getModuleLoaderInjector()).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, dependencies.getMBeanServerInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (transportConfig != null) {
            if (transportExecutor != null) {
                CacheContainerAddHandler.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, transportExecutor, transportConfig.getExecutorInjector());
            }
            configBuilder.addDependency(ChannelService.getServiceName((String)containerName), Channel.class, transportConfig.getChannelInjector());
            configBuilder.addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, transportConfig.getChannelFactoryInjector());
        }
        CacheContainerAddHandler.addExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, listenerExecutor, dependencies.getListenerExecutorInjector());
        CacheContainerAddHandler.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, evictionExecutor, dependencies.getEvictionExecutorInjector());
        CacheContainerAddHandler.addScheduledExecutorDependency((ServiceBuilder<EmbeddedCacheManagerConfiguration>)configBuilder, replicationQueueExecutor, dependencies.getReplicationQueueExecutorInjector());
        return configBuilder.install();
    }

    private static ServiceController<?> installContainerService(ServiceTarget target, String containerName, ServiceName[] aliases, Transport transport, ServiceController.Mode initialMode, ServiceVerificationHandler verificationHandler) {
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(containerName);
        ServiceName configServiceName = EmbeddedCacheManagerConfigurationService.getServiceName(containerName);
        InjectedValue config = new InjectedValue();
        EmbeddedCacheManagerService service = new EmbeddedCacheManagerService((Value<EmbeddedCacheManagerConfiguration>)config);
        ServiceBuilder builder = target.addService(containerServiceName, (Service)service).addDependency(configServiceName, EmbeddedCacheManagerConfiguration.class, (Injector)config).addAliases(aliases).setInitialMode(initialMode);
        if (transport != null) {
            builder.addDependency(ChannelService.getServiceName((String)containerName));
        }
        return builder.install();
    }

    private static ServiceController<?> installJndiService(ServiceTarget target, String containerName, String jndiName, ServiceVerificationHandler verificationHandler) {
        ServiceName name = EmbeddedCacheManagerService.getServiceName(containerName);
        ContextNames.BindInfo binding = CacheContainerAddHandler.createCacheContainerBinding(jndiName, containerName);
        return new BinderServiceBuilder(target).build(binding, name, CacheContainer.class).install();
    }

    private static void addExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<Executor> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), Executor.class, injector);
        }
    }

    private static void addScheduledExecutorDependency(ServiceBuilder<EmbeddedCacheManagerConfiguration> builder, String executor, Injector<ScheduledExecutorService> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), ScheduledExecutorService.class, injector);
        }
    }

    private static ContextNames.BindInfo createCacheContainerBinding(String jndiName, String container) {
        JndiName name = jndiName != null ? JndiNameFactory.parse((String)jndiName) : JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"infinispan", "container", container});
        return ContextNames.bindInfoFor((String)name.getAbsoluteName());
    }

    private static ContextNames.BindInfo createChannelBinding(String channel) {
        return ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"jgroups", "channel", channel}).getAbsoluteName());
    }

    static class Transport
    implements EmbeddedCacheManagerConfigurationService.TransportConfiguration {
        private final InjectedValue<ChannelFactory> channelFactory = new InjectedValue();
        private final InjectedValue<Channel> channel = new InjectedValue();
        private final InjectedValue<Executor> executor = new InjectedValue();
        private Long lockTimeout;
        private String clusterName;

        Transport() {
        }

        void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }

        void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        Injector<ChannelFactory> getChannelFactoryInjector() {
            return this.channelFactory;
        }

        Injector<Executor> getExecutorInjector() {
            return this.executor;
        }

        Injector<Channel> getChannelInjector() {
            return this.channel;
        }

        @Override
        public Channel getChannel() {
            return (Channel)this.channel.getValue();
        }

        @Override
        public ChannelFactory getChannelFactory() {
            return (ChannelFactory)this.channelFactory.getValue();
        }

        @Override
        public Executor getExecutor() {
            return (Executor)this.executor.getOptionalValue();
        }

        @Override
        public Long getLockTimeout() {
            return this.lockTimeout;
        }

        @Override
        public String getClusterName() {
            return this.clusterName;
        }
    }

    static class EmbeddedCacheManagerDependencies
    implements EmbeddedCacheManagerConfigurationService.Dependencies {
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> evictionExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
        private final EmbeddedCacheManagerConfigurationService.TransportConfiguration transport;
        private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();

        EmbeddedCacheManagerDependencies(EmbeddedCacheManagerConfigurationService.TransportConfiguration transport) {
            this.transport = transport;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<Executor> getListenerExecutorInjector() {
            return this.listenerExecutor;
        }

        Injector<ScheduledExecutorService> getEvictionExecutorInjector() {
            return this.evictionExecutor;
        }

        Injector<ScheduledExecutorService> getReplicationQueueExecutorInjector() {
            return this.replicationQueueExecutor;
        }

        Injector<ModuleLoader> getModuleLoaderInjector() {
            return this.moduleLoader;
        }

        @Override
        public EmbeddedCacheManagerConfigurationService.TransportConfiguration getTransportConfiguration() {
            return this.transport;
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public Executor getListenerExecutor() {
            return (Executor)this.listenerExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getEvictionExecutor() {
            return (ScheduledExecutorService)this.evictionExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getReplicationQueueExecutor() {
            return (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return (ModuleLoader)this.moduleLoader.getValue();
        }
    }
}

