/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.clustering.infinispan.subsystem.CacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheAddHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;

public class CacheRemoveHandler
extends AbstractRemoveStepHandler {
    static final CacheRemoveHandler INSTANCE = new CacheRemoveHandler();
    private final Map<String, CacheAddHandler> handlers = new HashMap<String, CacheAddHandler>();

    CacheRemoveHandler() {
        this.handlers.put("local-cache", LocalCacheAddHandler.INSTANCE);
        this.handlers.put("invalidation-cache", InvalidationCacheAddHandler.INSTANCE);
        this.handlers.put("replicated-cache", ReplicatedCacheAddHandler.INSTANCE);
        this.handlers.put("distributed-cache", DistributedCacheAddHandler.INSTANCE);
    }

    Set<String> getCacheTypes() {
        return this.handlers.keySet();
    }

    CacheAddHandler getAddHandler(String cacheType) {
        CacheAddHandler handler = this.handlers.get(cacheType);
        if (handler == null) {
            throw new IllegalArgumentException(cacheType);
        }
        return handler;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        String cacheType = CacheRemoveHandler.getCacheType(operation);
        CacheAddHandler addHandler = this.getAddHandler(cacheType);
        addHandler.removeRuntimeServices(context, operation, containerModel, model);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode cacheModel) throws OperationFailedException {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        String cacheType = CacheRemoveHandler.getCacheType(operation);
        ServiceVerificationHandler verificationHandler = null;
        CacheAddHandler addHandler = this.getAddHandler(cacheType);
        addHandler.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler);
    }

    private static String getCacheType(ModelNode operation) {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        return cacheAddress.getLastElement().getKey();
    }
}

