/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheMetric;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ClusteredCacheMetricsHandler
extends AbstractRuntimeOnlyHandler {
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String containerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getLastElement().getValue();
        String name = operation.require("name").asString();
        ClusteredCacheMetric metric = ClusteredCacheMetric.forName(name);
        if (metric == null) {
            context.getFailureDescription().set(InfinispanLogger.ROOT_LOGGER.unknownMetric(name));
        } else {
            Cache cache = (Cache)ServiceContainerHelper.findValue((ServiceRegistry)context.getServiceRegistry(false), (ServiceName)CacheService.getServiceName(containerName, cacheName));
            if (cache != null) {
                context.getResult().set(metric.getValue((RpcManagerImpl)cache.getAdvancedCache().getRpcManager()));
            }
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }
}

