/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSchema;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemXMLReader;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemXMLWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class InfinispanExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "infinispan";
    private static final String RESOURCE_NAME = InfinispanExtension.class.getPackage().getName() + ".LocalDescriptions";

    static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new InfinispanResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, InfinispanExtension.class.getClassLoader());
    }

    public void initialize(ExtensionContext context) {
        ModelVersion current = InfinispanModel.CURRENT.getVersion();
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, current.getMajor(), current.getMinor(), current.getMicro());
        ResolvePathHandler resolvePathHandler = context.getProcessType().isServer() ? ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)FileStoreResourceDefinition.RELATIVE_PATH).setRelativeToAttribute((AttributeDefinition)FileStoreResourceDefinition.RELATIVE_TO).build() : null;
        registration.registerSubsystemModel((ResourceDefinition)new InfinispanSubsystemResourceDefinition(resolvePathHandler, context.isRuntimeOnlyRegistrationValid()));
        registration.registerXMLElementWriter((XMLElementWriter)new InfinispanSubsystemXMLWriter());
        if (context.isRegisterTransformers()) {
            for (InfinispanModel model : EnumSet.complementOf(EnumSet.of(InfinispanModel.CURRENT))) {
                ModelVersion version = model.getVersion();
                TransformationDescription.Tools.register((TransformationDescription)InfinispanSubsystemResourceDefinition.buildTransformation(version), (SubsystemRegistration)registration, (ModelVersionRange)version);
            }
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (InfinispanSchema schema : InfinispanSchema.values()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new InfinispanSubsystemXMLReader(schema));
        }
    }
}

