/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.InputStream;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class OperationsTestCase
extends OperationTestCaseBase {
    @Test
    public void testSubsystemReadWriteOperations() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getSubsystemReadOperation((Attribute)JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK), new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"maximal", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(OperationsTestCase.getSubsystemWriteOperation((Attribute)JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK, "new-default"), new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getSubsystemReadOperation((Attribute)JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK), new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-default", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getTransportReadOperation("maximal", "TCP", (Attribute)TransportResourceDefinition.Attribute.RACK), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"rack1", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(OperationsTestCase.getTransportWriteOperation("maximal", "TCP", (Attribute)TransportResourceDefinition.Attribute.RACK, "new-rack"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportReadOperation("maximal", "TCP", (Attribute)TransportResourceDefinition.Attribute.RACK), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-rack", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportReadWriteWithParameters() throws Exception {
        KernelServices services = this.buildKernelServices();
        Assert.assertTrue((String)"Could not create services", (boolean)services.isSuccessfulBoot());
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolStackAddOperationWithParameters("maximal2"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportWriteOperation("maximal", "TCP", (Attribute)TransportResourceDefinition.Attribute.RACK, "new-rack"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportReadOperation("maximal", "TCP", (Attribute)TransportResourceDefinition.Attribute.RACK), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-rack", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportPropertyReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "enable_bundling"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"true", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(OperationsTestCase.getTransportPutPropertyOperation("maximal", "TCP", "enable_bundling", "false"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "enable_bundling"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "enable_bundling"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "enable_bundling"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
        result = services.executeOperation(OperationsTestCase.getTransportPropertyAddOperation("maximal", "TCP", "shared", "false"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportPropertyReadOperation("maximal", "TCP", "shared"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "shared"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getTransportPropertyWriteOperation("maximal", "TCP", "shared", "true"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportPropertyReadOperation("maximal", "TCP", "shared"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"true", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "shared"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"true", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getTransportPropertyRemoveOperation("maximal", "TCP", "shared"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "shared"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
    }

    @Test
    public void testProtocolReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolStackAddOperationWithParameters("maximal2"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolReadOperation("maximal", "MPING", (Attribute)ProtocolResourceDefinition.Attribute.SOCKET_BINDING), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"jgroups-mping", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolWriteOperation("maximal", "MPING", (Attribute)ProtocolResourceDefinition.Attribute.SOCKET_BINDING, "new-socket-binding"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolReadOperation("maximal", "MPING", (Attribute)ProtocolResourceDefinition.Attribute.SOCKET_BINDING), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-socket-binding", (Object)result.get("result").asString());
    }

    @Test
    public void testProtocolPropertyReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"value", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(OperationsTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "name", "new-value"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-value", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
        result = services.executeOperation(OperationsTestCase.getProtocolPropertyAddOperation("maximal", "MPING", "async_discovery", "false"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolPropertyReadOperation("maximal", "MPING", "async_discovery"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "async_discovery"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolPropertyWriteOperation("maximal", "MPING", "async_discovery", "true"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolPropertyReadOperation("maximal", "MPING", "async_discovery"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"true", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "async_discovery"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"true", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolPropertyRemoveOperation("maximal", "MPING", "async_discovery"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "async_discovery"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
    }
}

