/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.InputStream;
import java.util.List;
import org.jboss.as.clustering.controller.RequiredCapability;
import org.jboss.as.clustering.controller.Requirement;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class TransformersTestCase
extends OperationTestCaseBase {
    private static String formatSubsystemArtifact(ModelTestControllerVersion version) {
        return TransformersTestCase.formatArtifact("org.wildfly:wildfly-clustering-jgroups:%s", version);
    }

    private static String formatLegacySubsystemArtifact(ModelTestControllerVersion version) {
        return TransformersTestCase.formatArtifact("org.jboss.as:jboss-as-clustering-jgroups:%s", version);
    }

    private static String formatArtifact(String pattern, ModelTestControllerVersion version) {
        return String.format(pattern, version.getMavenGavVersion());
    }

    protected org.jboss.as.clustering.subsystem.AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require((Requirement)RequiredCapability.SOCKET_BINDING, new String[]{"jgroups-tcp", "jgroups-udp", "jgroups-udp-fd", "some-binding", "jgroups-diagnostics", "jgroups-mping", "jgroups-tcp-fd", "jgroups-state-xfr"});
    }

    @Test
    public void testTransformerWF800() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_0_0_FINAL;
        this.testTransformation(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testTransformerWF810() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_1_0_FINAL;
        this.testTransformation(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP620() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_2_0;
        this.testTransformation(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP630() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_3_0;
        this.testTransformation(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP640() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_4_0;
        this.testTransformation(JGroupsModel.VERSION_1_3_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    private void testTransformation(JGroupsModel model, ModelTestControllerVersion controller, String ... mavenResourceURLs) throws Exception {
        ModelVersion version = model.getVersion();
        KernelServicesBuilder builder = this.createKernelServicesBuilder((AdditionalInitialization)this.createAdditionalInitialization()).setSubsystemXmlResource("subsystem-jgroups-transform.xml");
        builder.createLegacyKernelServicesBuilder(null, controller, version).addMavenResourceURL(mavenResourceURLs).skipReverseControllerCheck();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)((KernelServices)services.getLegacyServices(version)).isSuccessfulBoot());
        this.checkSubsystemModelTransformation(services, version);
        this.propertiesMapOperationsTest(services, version);
        this.testNonMapTransformersWork(services, version);
    }

    private void propertiesMapOperationsTest(KernelServices services, ModelVersion version) throws Exception {
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getTransportUndefinePropertiesOperation("maximal", "TCP"));
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), new String[0]);
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "true"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), "tcp_nodelay", "true");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "loopback", "false"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.checkMapResults(services, new ModelNode("false"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), "tcp_nodelay", "true", "loopback", "false");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "loopback", "true"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), "tcp_nodelay", "true", "loopback", "true");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.checkMapResults(services, new ModelNode(), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), "loopback", "true");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "false"));
        this.checkMapResults(services, new ModelNode("false"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), "tcp_nodelay", "false", "loopback", "true");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getTransportClearPropertiesOperation("maximal", "TCP"));
        this.checkMapResults(services, new ModelNode(), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.checkMapResults(services, new ModelNode(), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), new String[0]);
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getProtocolUndefinePropertiesOperation("maximal", "MPING"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), new String[0]);
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "true"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), "send_on_all_interfaces", "true");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "false"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode("false"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), "send_on_all_interfaces", "true", "receive_on_all_interfaces", "false");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode(), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), "send_on_all_interfaces", "true");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode(), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), new String[0]);
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "true"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), "receive_on_all_interfaces", "true");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "false"));
        this.checkMapResults(services, new ModelNode("false"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), "receive_on_all_interfaces", "false");
        this.executeOpInBothControllersWithAttachments(services, version, TransformersTestCase.getProtocolClearPropertiesOperation("maximal", "MPING"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), new String[0]);
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "false"));
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "true"));
        composite.get("steps").add(TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "true"));
        this.executeOpInBothControllersWithAttachments(services, version, composite);
        this.checkMapResults(services, new ModelNode("false"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        composite.get("steps").setEmptyList();
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "true"));
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "false"));
        composite.get("steps").add(TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "false"));
        this.executeOpInBothControllersWithAttachments(services, version, composite);
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode("false"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode("false"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), "send_on_all_interfaces", "true", "receive_on_all_interfaces", "false");
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), "tcp_nodelay", "false");
        composite.get("steps").setEmptyList();
        composite.get("steps").add(TransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        composite.get("steps").add(TransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        composite.get("steps").add(TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "loopback", "false"));
        composite.get("steps").add(TransformersTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.executeOpInBothControllersWithAttachments(services, version, composite);
        this.checkMapResults(services, new ModelNode(), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode(), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode(), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        this.checkMapResults(services, new ModelNode("false"), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), new String[0]);
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), "loopback", "false");
        composite.get("steps").setEmptyList();
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "false"));
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "true"));
        composite.get("steps").add(TransformersTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "loopback"));
        this.executeOpInBothControllersWithAttachments(services, version, composite);
        this.checkMapResults(services, new ModelNode("false"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode("true"), version, TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        this.checkMapResults(services, new ModelNode(), version, TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        this.checkMapModels(services, version, TransformersTestCase.getProtocolAddress("maximal", "MPING"), "send_on_all_interfaces", "false", "receive_on_all_interfaces", "true");
        this.checkMapModels(services, version, TransformersTestCase.getTransportAddress("maximal", "TCP"), new String[0]);
    }

    private void testNonMapTransformersWork(KernelServices services, ModelVersion version) throws Exception {
        PathAddress stackAddr = PathAddress.pathAddress((String)"subsystem", (String)this.getMainSubsystemName()).append("stack", "test");
        ModelNode addStack = Util.createAddOperation((PathAddress)stackAddr);
        this.executeOpInBothControllersWithAttachments(services, version, addStack);
        PathAddress transportAddr = stackAddr.append("transport", "tcp");
        ModelNode addTransport = Util.createAddOperation((PathAddress)transportAddr);
        addTransport.get("module").set("do.reject");
        OperationTransformer.TransformedOperation op = services.executeInMainAndGetTheTransformedOperation(addTransport, version);
        Assert.assertTrue((boolean)op.rejectOperation(TransformersTestCase.success()));
        PathAddress protocolAddr = stackAddr.append("protocol", "MPING");
        ModelNode addProtocol = Util.createAddOperation((PathAddress)protocolAddr);
        addProtocol.get("module").set("do.reject");
        op = services.executeInMainAndGetTheTransformedOperation(addProtocol, version);
        Assert.assertTrue((boolean)op.rejectOperation(TransformersTestCase.success()));
        op = services.executeInMainAndGetTheTransformedOperation(Util.getWriteAttributeOperation((PathAddress)transportAddr, (String)"module", (String)"reject.this"), version);
        Assert.assertTrue((boolean)op.rejectOperation(TransformersTestCase.success()));
        op = services.executeInMainAndGetTheTransformedOperation(Util.getWriteAttributeOperation((PathAddress)protocolAddr, (String)"module", (String)"reject.this"), version);
        Assert.assertTrue((boolean)op.rejectOperation(TransformersTestCase.success()));
    }

    private void checkMapResults(KernelServices services, ModelNode expected, ModelVersion version, ModelNode operation) throws Exception {
        ModelNode legacy;
        ModelNode main = ModelTestUtils.checkOutcome((ModelNode)services.executeOperation(operation.clone(), new InputStream[0])).get("result");
        ModelNode legacyResult = services.executeOperation(version, services.transformOperation(version, operation.clone()));
        if (expected.isDefined()) {
            legacy = ModelTestUtils.checkOutcome((ModelNode)legacyResult).get("result");
        } else {
            ModelTestUtils.checkFailed((ModelNode)legacyResult);
            legacy = new ModelNode();
        }
        Assert.assertEquals((Object)main, (Object)legacy);
        Assert.assertEquals((Object)expected, (Object)legacy);
    }

    private void checkMapModels(KernelServices services, ModelVersion version, PathAddress address, String ... properties) throws Exception {
        ModelNode legacyModel;
        ModelNode readResource = Util.createEmptyOperation((String)"read-resource", (PathAddress)address);
        readResource.get("recursive").set(true);
        readResource.get("include-defaults").set(false);
        ModelNode mainModel = services.executeForResult(readResource.clone(), new InputStream[0]);
        this.checkMainMapModel(mainModel, properties);
        if (address.getLastElement().getKey().equals("transport")) {
            readResource.get("address").set(address.subAddress(0, address.size() - 1).append("transport", "TRANSPORT").toModelNode());
            legacyModel = ((KernelServices)services.getLegacyServices(version)).executeForResult(readResource, new InputStream[0]);
        } else {
            legacyModel = ModelTestUtils.checkResultAndGetContents((ModelNode)services.executeOperation(version, services.transformOperation(version, readResource.clone())));
        }
        this.checkLegacyChildResourceModel(legacyModel, properties);
    }

    private void checkMainMapModel(ModelNode model, String ... properties) {
        Assert.assertEquals((long)0L, (long)(properties.length % 2));
        ModelNode props = model.get("properties");
        Assert.assertEquals((long)(properties.length / 2), (long)(props.isDefined() ? (long)props.keys().size() : 0L));
        for (int i = 0; i < properties.length; i += 2) {
            Assert.assertEquals((Object)properties[i + 1], (Object)props.get(properties[i]).asString());
        }
    }

    private void checkLegacyChildResourceModel(ModelNode model, String ... properties) {
        Assert.assertEquals((long)0L, (long)(properties.length % 2));
        ModelNode props = model.get("property");
        Assert.assertEquals((long)(properties.length / 2), (long)(props.isDefined() ? (long)props.keys().size() : 0L));
        for (int i = 0; i < properties.length; i += 2) {
            ModelNode property = props.get(properties[i]);
            Assert.assertTrue((boolean)property.isDefined());
            Assert.assertEquals((long)1L, (long)property.keys().size());
            Assert.assertEquals((Object)properties[i + 1], (Object)property.get("value").asString());
        }
    }

    @Ignore
    @Test
    @BMRule(name="Test support for expression resolution", targetClass="^org.jboss.as.controller.AbstractAddStepHandler", targetMethod="performRuntime", targetLocation="AT ENTRY", binding="context:OperationContext = $1; operation:ModelNode = $2; model:ModelNode = $3", condition="operation.hasDefined(\"name\") AND operation.hasDefined(\"value\")", action="traceln(\"resolved value = \" + org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition.VALUE.resolveModelAttribute(context,model))")
    public void testProtocolStackPropertyResolve() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices services = this.createKernelServicesBuilder(null).setSubsystemXmlResource(subsystemXml).build();
        ModelNode operation = TransformersTestCase.getTransportPropertyAddOperation("maximal", "TCP", "bundler_type", "${the_bundler_type:new}");
        ModelNode mainResult = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)mainResult.toJSONString(true), (Object)"success", (Object)mainResult.get("outcome").asString());
    }

    @Test
    public void testRejectionsWF800() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_0_0_FINAL;
        this.testRejections(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testRejectionsWF810() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_1_0_FINAL;
        this.testRejections(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP620() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_2_0;
        this.testRejections(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP630() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_3_0;
        this.testRejections(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP640() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_4_0;
        this.testRejections(JGroupsModel.VERSION_1_3_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    private void testRejections(JGroupsModel model, ModelTestControllerVersion controller, String ... dependencies) throws Exception {
        ModelVersion version = model.getVersion();
        KernelServicesBuilder builder = this.createKernelServicesBuilder((AdditionalInitialization)this.createAdditionalInitialization());
        builder.createLegacyKernelServicesBuilder(null, controller, version).addMavenResourceURL(dependencies).dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List operations = builder.parseXmlResource("subsystem-jgroups-transform-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)version, (List)operations, (FailedOperationTransformationConfig)TransformersTestCase.createFailedOperationTransformationConfig(version));
    }

    private static FailedOperationTransformationConfig createFailedOperationTransformationConfig(ModelVersion version) {
        FailedOperationTransformationConfig config = new FailedOperationTransformationConfig();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{TransportResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{ThreadPoolResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        if (JGroupsModel.VERSION_2_0_0.requiresTransformation(version)) {
            PathAddress stackAddress = subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH});
            PathAddress relayAddress = stackAddress.append(new PathElement[]{RelayResourceDefinition.PATH});
            config.addFailedAttribute(relayAddress, FailedOperationTransformationConfig.REJECTED_RESOURCE);
            config.addFailedAttribute(relayAddress.append(new PathElement[]{RemoteSiteResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        return config;
    }

    private static ModelNode success() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("success");
        result.get("result");
        return result;
    }
}

