/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.InputStream;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;

@RunWith(value=BMUnitRunner.class)
public class OperationSequencesTestCase
extends OperationTestCaseBase {
    static final ModelNode addStackOp = OperationSequencesTestCase.getProtocolStackAddOperation("maximal2");
    static final ModelNode addStackOpWithParams = OperationSequencesTestCase.getProtocolStackAddOperationWithParameters("maximal2");
    static final ModelNode removeStackOp = OperationSequencesTestCase.getProtocolStackRemoveOperation("maximal2");
    static final ModelNode addTransportOp = OperationSequencesTestCase.getTransportAddOperation("maximal2", "UDP");
    static final ModelNode addTransportOpWithProps = OperationSequencesTestCase.getTransportAddOperationWithProperties("maximal2", "UDP");
    static final ModelNode removeTransportOp = OperationSequencesTestCase.getTransportRemoveOperation("maximal2", "UDP");
    static final ModelNode addProtocolOp = OperationSequencesTestCase.getProtocolAddOperation("maximal2", "MPING");
    static final ModelNode addProtocolOpWithProps = OperationSequencesTestCase.getProtocolAddOperationWithProperties("maximal2", "MPING");
    static final ModelNode removeProtocolOp = OperationSequencesTestCase.getProtocolRemoveOperation("maximal2", "MPING");

    @Test
    public void testProtocolStackAddRemoveAddSequence() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode operation = Operations.createCompositeOperation((ModelNode[])new ModelNode[]{addStackOp, addTransportOp, addProtocolOp});
        ModelNode result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(removeStackOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
    }

    @Test
    public void testProtocolStackRemoveRemoveSequence() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode operation = Operations.createCompositeOperation((ModelNode[])new ModelNode[]{addStackOp, addTransportOp, addProtocolOp});
        ModelNode result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(removeStackOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(removeStackOp, new InputStream[0]);
        Assert.assertEquals((Object)"failed", (Object)result.get("outcome").asString());
    }

    @Test
    public void testProtocolStackAddRemoveSequenceWithParameters() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(addStackOpWithParams, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(removeStackOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(removeStackOp, new InputStream[0]);
        Assert.assertEquals((Object)"failed", (Object)result.get("outcome").asString());
    }

    @Test
    public void testLegacyTransportAliasSequence() throws Exception {
        KernelServices services = this.buildKernelServices();
        String stackName = "legacyStack";
        ModelNode result = services.executeOperation(OperationSequencesTestCase.getProtocolStackAddOperationWithParameters(stackName), new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationSequencesTestCase.getLegacyThreadPoolAddOperation(stackName, "default"), new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        ModelNode op = OperationSequencesTestCase.getLegacyThreadPoolAddOperation(stackName, "default");
        op.get("operation").set("write-attribute");
        op.get("name").set("keepalive-time");
        op.get("value").set(999);
        result = services.executeOperation(op, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        op = Operations.createReadResourceOperation((PathAddress)OperationSequencesTestCase.getSubsystemAddress());
        op.get("include-aliases").set("true");
        op.get("recursive").set("true");
        result = services.executeOperation(op, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        op = Util.createOperation((String)"read-resource-description", (PathAddress)OperationSequencesTestCase.getSubsystemAddress());
        op.get("include-aliases").set("true");
        op.get("recursive").set("true");
        result = services.executeOperation(op, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationSequencesTestCase.getLegacyTransportRemoveOperation(stackName), new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationSequencesTestCase.getLegacyTransportAddOperation(stackName, "TCP"), new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationSequencesTestCase.getLegacyTransportRemoveOperation(stackName), new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationSequencesTestCase.getLegacyTransportRemoveOperation(stackName), new InputStream[0]);
        Assert.assertEquals((Object)"failed", (Object)result.get("outcome").asString());
    }

    @Ignore(value="This fails for some mysterious reason - but this isn't a critical test")
    @Test
    @BMRule(name="Test remove rollback operation", targetClass="org.jboss.as.clustering.jgroups.subsystem.StackRemoveHandler", targetMethod="performRuntime", targetLocation="AT EXIT", action="traceln(\"Injecting rollback fault via Byteman\");$1.setRollbackOnly()")
    public void testProtocolStackRemoveRollback() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode operation = Operations.createCompositeOperation((ModelNode[])new ModelNode[]{addStackOp, addTransportOp, addProtocolOp});
        ModelNode result = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(removeStackOp, new InputStream[0]);
        Assert.assertEquals((Object)"failed", (Object)result.get("outcome").asString());
        ServiceName channelFactoryServiceName = ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName("maximal2");
        Assert.assertNotNull((String)"channel factory service not installed", (Object)services.getContainer().getService(channelFactoryServiceName));
    }
}

