/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.InputStream;
import java.util.List;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.PropertiesTestUtil;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.clustering.service.Requirement;

@RunWith(value=BMUnitRunner.class)
public class TransformersTestCase
extends OperationTestCaseBase {
    private static String formatSubsystemArtifact(ModelTestControllerVersion version) {
        return TransformersTestCase.formatArtifact("org.wildfly:wildfly-clustering-jgroups:%s", version);
    }

    private static String formatLegacySubsystemArtifact(ModelTestControllerVersion version) {
        return TransformersTestCase.formatArtifact("org.jboss.as:jboss-as-clustering-jgroups:%s", version);
    }

    private static String formatArtifact(String pattern, ModelTestControllerVersion version) {
        return String.format(pattern, version.getMavenGavVersion());
    }

    protected org.jboss.as.clustering.subsystem.AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require((Requirement)CommonUnaryRequirement.SOCKET_BINDING, new String[]{"jgroups-tcp", "jgroups-udp", "jgroups-udp-fd", "some-binding", "jgroups-diagnostics", "jgroups-mping", "jgroups-tcp-fd", "jgroups-state-xfr"});
    }

    @Test
    public void testTransformerWF800() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_0_0_FINAL;
        this.testTransformation(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testTransformerWF810() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_1_0_FINAL;
        this.testTransformation(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP620() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_2_0;
        this.testTransformation(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP630() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_3_0;
        this.testTransformation(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testTransformerEAP640() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_4_0;
        this.testTransformation(JGroupsModel.VERSION_1_3_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    private void testTransformation(JGroupsModel model, ModelTestControllerVersion controller, String ... mavenResourceURLs) throws Exception {
        ModelVersion version = model.getVersion();
        KernelServicesBuilder builder = this.createKernelServicesBuilder((AdditionalInitialization)this.createAdditionalInitialization()).setSubsystemXmlResource("subsystem-jgroups-transform.xml");
        builder.createLegacyKernelServicesBuilder(null, controller, version).addMavenResourceURL(mavenResourceURLs).skipReverseControllerCheck();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)((KernelServices)services.getLegacyServices(version)).isSuccessfulBoot());
        this.checkSubsystemModelTransformation(services, version);
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            this.propertiesMapOperationsTest(services, version);
            this.testNonMapTransformersWork(services, version);
        }
    }

    private void propertiesMapOperationsTest(KernelServices services, ModelVersion version) throws Exception {
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportUndefinePropertiesOperation("maximal", "TCP"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[0]);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "true"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "loopback", "false"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "true", "loopback", "false"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "loopback", "true"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "true", "loopback", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"loopback", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "false"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "false", "loopback", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportClearPropertiesOperation("maximal", "TCP"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[0]);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolUndefinePropertiesOperation("maximal", "MPING"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[0]);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "true"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "false"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "true", "receive_on_all_interfaces", "false"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[0]);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "true"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"receive_on_all_interfaces", "true"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "false"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"receive_on_all_interfaces", "false"});
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolClearPropertiesOperation("maximal", "MPING"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[0]);
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "false"));
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "true"));
        composite.get("steps").add(TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "true"));
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)composite);
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        composite.get("steps").setEmptyList();
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "true"));
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "false"));
        composite.get("steps").add(TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "tcp_nodelay", "false"));
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)composite);
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "true", "receive_on_all_interfaces", "false"});
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"tcp_nodelay", "false"});
        composite.get("steps").setEmptyList();
        composite.get("steps").add(TransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        composite.get("steps").add(TransformersTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        composite.get("steps").add(TransformersTestCase.getTransportPutPropertyOperation("maximal", "TCP", "loopback", "false"));
        composite.get("steps").add(TransformersTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)composite);
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "tcp_nodelay"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[0]);
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[]{"loopback", "false"});
        composite.get("steps").setEmptyList();
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "send_on_all_interfaces", "false"));
        composite.get("steps").add(TransformersTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "receive_on_all_interfaces", "true"));
        composite.get("steps").add(TransformersTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)composite);
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("false"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "send_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode("true"), (ModelVersion)version, (ModelNode)TransformersTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "receive_on_all_interfaces"));
        PropertiesTestUtil.checkMapResults((KernelServices)services, (ModelNode)new ModelNode(), (ModelVersion)version, (ModelNode)TransformersTestCase.getTransportGetPropertyOperation("maximal", "TCP", "loopback"));
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getProtocolAddress("maximal", "MPING"), (String[])new String[]{"send_on_all_interfaces", "false", "receive_on_all_interfaces", "true"});
        PropertiesTestUtil.checkMapModels((KernelServices)services, (ModelVersion)version, (PathAddress)TransformersTestCase.getTransportAddress("maximal", "TCP"), (String[])new String[0]);
    }

    private void testNonMapTransformersWork(KernelServices services, ModelVersion version) throws Exception {
        PathAddress stackAddr = PathAddress.pathAddress((String)"subsystem", (String)this.getMainSubsystemName()).append("stack", "test");
        ModelNode addStack = Util.createAddOperation((PathAddress)stackAddr);
        PropertiesTestUtil.executeOpInBothControllersWithAttachments((KernelServices)services, (ModelVersion)version, (ModelNode)addStack);
        PathAddress transportAddr = stackAddr.append("transport", "tcp");
        ModelNode addTransport = Util.createAddOperation((PathAddress)transportAddr);
        addTransport.get("module").set("do.reject");
        OperationTransformer.TransformedOperation op = services.executeInMainAndGetTheTransformedOperation(addTransport, version);
        Assert.assertTrue((boolean)op.rejectOperation(TransformersTestCase.success()));
        PathAddress protocolAddr = stackAddr.append("protocol", "MPING");
        ModelNode addProtocol = Util.createAddOperation((PathAddress)protocolAddr);
        addProtocol.get("module").set("do.reject");
        op = services.executeInMainAndGetTheTransformedOperation(addProtocol, version);
        Assert.assertTrue((boolean)op.rejectOperation(TransformersTestCase.success()));
        op = services.executeInMainAndGetTheTransformedOperation(Util.getWriteAttributeOperation((PathAddress)transportAddr, (String)"module", (String)"reject.this"), version);
        Assert.assertTrue((boolean)op.rejectOperation(TransformersTestCase.success()));
        op = services.executeInMainAndGetTheTransformedOperation(Util.getWriteAttributeOperation((PathAddress)protocolAddr, (String)"module", (String)"reject.this"), version);
        Assert.assertTrue((boolean)op.rejectOperation(TransformersTestCase.success()));
    }

    @Ignore
    @Test
    @BMRule(name="Test support for expression resolution", targetClass="^org.jboss.as.controller.AbstractAddStepHandler", targetMethod="performRuntime", targetLocation="AT ENTRY", binding="context:OperationContext = $1; operation:ModelNode = $2; model:ModelNode = $3", condition="operation.hasDefined(\"name\") AND operation.hasDefined(\"value\")", action="traceln(\"resolved value = \" + org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition.VALUE.resolveModelAttribute(context,model))")
    public void testProtocolStackPropertyResolve() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices services = this.createKernelServicesBuilder(null).setSubsystemXmlResource(subsystemXml).build();
        ModelNode operation = TransformersTestCase.getTransportPropertyAddOperation("maximal", "TCP", "bundler_type", "${the_bundler_type:new}");
        ModelNode mainResult = services.executeOperation(operation, new InputStream[0]);
        Assert.assertEquals((String)mainResult.toJSONString(true), (Object)"success", (Object)mainResult.get("outcome").asString());
    }

    @Test
    public void testRejectionsWF800() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_0_0_FINAL;
        this.testRejections(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testRejectionsWF810() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.WILDFLY_8_1_0_FINAL;
        this.testRejections(JGroupsModel.VERSION_2_0_0, version, TransformersTestCase.formatSubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP620() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_2_0;
        this.testRejections(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP630() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_3_0;
        this.testRejections(JGroupsModel.VERSION_1_2_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    @Test
    public void testRejectionsEAP640() throws Exception {
        ModelTestControllerVersion version = ModelTestControllerVersion.EAP_6_4_0;
        this.testRejections(JGroupsModel.VERSION_1_3_0, version, TransformersTestCase.formatLegacySubsystemArtifact(version));
    }

    private void testRejections(JGroupsModel model, ModelTestControllerVersion controller, String ... dependencies) throws Exception {
        ModelVersion version = model.getVersion();
        KernelServicesBuilder builder = this.createKernelServicesBuilder((AdditionalInitialization)this.createAdditionalInitialization());
        builder.createLegacyKernelServicesBuilder(null, controller, version).addMavenResourceURL(dependencies).dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List operations = builder.parseXmlResource("subsystem-jgroups-transform-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)version, (List)operations, (FailedOperationTransformationConfig)TransformersTestCase.createFailedOperationTransformationConfig(version));
    }

    private static FailedOperationTransformationConfig createFailedOperationTransformationConfig(ModelVersion version) {
        FailedOperationTransformationConfig config = new FailedOperationTransformationConfig();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{TransportResourceDefinition.WILDCARD_PATH}).append(new PathElement[]{ThreadPoolResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        if (JGroupsModel.VERSION_2_0_0.requiresTransformation(version)) {
            PathAddress stackAddress = subsystemAddress.append(new PathElement[]{StackResourceDefinition.WILDCARD_PATH});
            PathAddress relayAddress = stackAddress.append(new PathElement[]{RelayResourceDefinition.PATH});
            config.addFailedAttribute(relayAddress, FailedOperationTransformationConfig.REJECTED_RESOURCE);
            config.addFailedAttribute(relayAddress.append(new PathElement[]{RemoteSiteResourceDefinition.WILDCARD_PATH}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        return config;
    }

    private static ModelNode success() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("success");
        result.get("result");
        return result;
    }
}

