/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Version;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.spi.GroupAliasBuilderProvider;

public class JGroupsSubsystemServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        JGroupsLogger.ROOT_LOGGER.activatingSubsystem(Version.printVersion());
        ServiceTarget target = context.getServiceTarget();
        PathAddress address = context.getCurrentAddress();
        if (context.getProcessType().isServer() && !context.isBooting() && context.readResourceFromRoot(address.getParent(), false).hasChild(PathElement.pathElement((String)"subsystem", (String)"infinispan"))) {
            context.addStep((ctx, operation) -> {
                ctx.reloadRequired();
                ctx.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
            }, OperationContext.Stage.RUNTIME);
            return;
        }
        new ProtocolDefaultsBuilder().build(target).install();
        ModelNodes.optionalString((ModelNode)JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.resolveModelAttribute((ExpressionResolver)context, model)).ifPresent(defaultChannel -> {
            JGroupsSubsystemResourceDefinition.CAPABILITIES.entrySet().forEach(entry -> new AliasServiceBuilder(((Capability)entry.getValue()).getServiceName(address), ((JGroupsRequirement)entry.getKey()).getServiceName(context, defaultChannel), ((JGroupsRequirement)entry.getKey()).getType()).build(target).install());
            if (!defaultChannel.equals("default")) {
                new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding("default"), JGroupsRequirement.CHANNEL.getServiceName(context, defaultChannel), JGroupsRequirement.CHANNEL.getType()).build(target).install();
                new BinderServiceBuilder(JGroupsBindingFactory.createChannelFactoryBinding("default"), JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, defaultChannel), JGroupsRequirement.CHANNEL_FACTORY.getType()).build(target).install();
            }
            for (GroupAliasBuilderProvider provider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
                for (CapabilityServiceBuilder builder : provider.getBuilders(requirement -> JGroupsSubsystemResourceDefinition.CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), null, defaultChannel)) {
                    builder.configure(context).build(target).install();
                }
            }
        });
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ModelNodes.optionalString((ModelNode)JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.resolveModelAttribute((ExpressionResolver)context, model)).ifPresent(defaultChannel -> {
            for (GroupAliasBuilderProvider provider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
                for (ServiceNameProvider builder : provider.getBuilders(requirement -> JGroupsSubsystemResourceDefinition.CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), null, defaultChannel)) {
                    context.removeService(builder.getServiceName());
                }
            }
            if (!defaultChannel.equals("default")) {
                context.removeService(JGroupsBindingFactory.createChannelFactoryBinding("default").getBinderServiceName());
                context.removeService(JGroupsBindingFactory.createChannelBinding("default").getBinderServiceName());
            }
            JGroupsSubsystemResourceDefinition.CAPABILITIES.values().forEach(capability -> context.removeService(capability.getServiceName(address)));
        });
        context.removeService(ProtocolDefaultsBuilder.SERVICE_NAME);
    }
}

