/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.clustering.jgroups.subsystem;

import java.util.function.Consumer;

import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

/**
 * Transformer for channel resources.
 * @author Paul Ferraro
 */
public class ChannelResourceTransformer implements Consumer<ModelVersion> {

    private final ResourceTransformationDescriptionBuilder builder;

    ChannelResourceTransformer(ResourceTransformationDescriptionBuilder parent) {
        DynamicDiscardPolicy discardAutoGeneratedChannel = new DynamicDiscardPolicy() {
            @Override
            public DiscardPolicy checkResource(TransformationContext context, PathAddress address) {
                // If this was an auto-generated channel, discard it
                @SuppressWarnings("deprecation")
                ModelNode defaultStack = context.readResourceFromRoot(address.getParent()).getModel().get(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK.getName());
                return context.readResourceFromRoot(address).getModel().get(ChannelResourceDefinition.Attribute.STACK.getName()).equals(defaultStack) ? DiscardPolicy.SILENT : DiscardPolicy.NEVER;
            }
        };
        this.builder = parent.addChildResource(ChannelResourceDefinition.WILDCARD_PATH, discardAutoGeneratedChannel);
    }

    @Override
    public void accept(ModelVersion version) {
        new ForkResourceTransformer(this.builder).accept(version);
    }
}
