/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.clustering.jgroups.ManagedSocketFactory;
import org.jboss.as.clustering.jgroups.TopologyAddressGenerator;
import org.jboss.as.network.SocketBinding;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.fork.UnknownForkHandler;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;

public class JChannelFactory
implements ChannelFactory {
    static final ByteBuffer UNKNOWN_FORK_RESPONSE = ByteBuffer.allocate(0);
    private final ProtocolStackConfiguration configuration;

    public JChannelFactory(ProtocolStackConfiguration configuration) {
        this.configuration = configuration;
    }

    public ProtocolStackConfiguration getProtocolStackConfiguration() {
        return this.configuration;
    }

    public JChannel createChannel(String id) throws Exception {
        final FORK fork = new FORK();
        fork.enableStats(this.configuration.isStatisticsEnabled());
        fork.setUnknownForkHandler(new UnknownForkHandler(){
            private final short id = ClassConfigurator.getProtocolId(RequestCorrelator.class);

            public Object handleUnknownForkStack(Message message, String forkStackId) {
                return this.handle(message);
            }

            public Object handleUnknownForkChannel(Message message, String forkChannelId) {
                return this.handle(message);
            }

            private Object handle(Message message) {
                RequestCorrelator.Header header = (RequestCorrelator.Header)message.getHeader(this.id);
                if (header != null && header.type == 0 && header.rspExpected()) {
                    Message response = message.makeReply().setFlag(message.getFlags()).clearFlag(new Message.Flag[]{Message.Flag.RSVP, Message.Flag.INTERNAL});
                    response.putHeader(FORK.ID, message.getHeader(FORK.ID));
                    response.putHeader(this.id, (Header)new RequestCorrelator.Header(1, header.req_id, header.corrId));
                    response.setBuffer(UNKNOWN_FORK_RESPONSE.array());
                    fork.getProtocolStack().getChannel().down(response);
                }
                return null;
            }
        });
        HashMap<String, SocketBinding> bindings = new HashMap<String, SocketBinding>();
        List<TransportConfiguration> transports = Collections.singletonList(this.configuration.getTransport());
        List relays = this.configuration.getRelay().isPresent() ? Collections.singletonList((ProtocolConfiguration)this.configuration.getRelay().get()) : Collections.emptyList();
        ArrayList<Object> protocols = new ArrayList<Object>(transports.size() + this.configuration.getProtocols().size() + relays.size() + 1);
        for (List protocolConfigs : Arrays.asList(transports, this.configuration.getProtocols(), relays)) {
            for (ProtocolConfiguration protocolConfig : protocolConfigs) {
                protocols.add(protocolConfig.createProtocol(this.configuration));
                bindings.putAll(protocolConfig.getSocketBindings());
            }
        }
        protocols.add(fork);
        ((Protocol)protocols.get(0)).setSocketFactory((SocketFactory)new ManagedSocketFactory(this.configuration.getSocketBindingManager(), bindings));
        JChannel channel = new JChannel(protocols);
        channel.setName(this.configuration.getNodeName());
        TransportConfiguration.Topology topology = this.configuration.getTransport().getTopology();
        if (topology != null) {
            channel.addAddressGenerator((AddressGenerator)new TopologyAddressGenerator(topology));
        }
        return channel;
    }

    public boolean isUnknownForkResponse(ByteBuffer response) {
        return UNKNOWN_FORK_RESPONSE.equals(response);
    }
}

