/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.jboss.as.clustering.jgroups.SocketFactory;
import org.jboss.as.network.ManagedServerSocketFactory;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jgroups.util.Util;
import org.wildfly.common.function.ExceptionFunction;

public class ManagedSocketFactory
implements SocketFactory {
    private final SelectorProvider provider;
    private final SocketBindingManager manager;
    private final Map<String, SocketBinding> bindings;
    private final Map<NetworkChannel, Closeable> channels = Collections.synchronizedMap(new IdentityHashMap());

    public ManagedSocketFactory(SelectorProvider provider, SocketBindingManager manager, Map<String, SocketBinding> socketBindings) {
        this.provider = provider;
        this.manager = manager;
        this.bindings = socketBindings;
    }

    public Socket createSocket(String name) throws IOException {
        SocketBinding binding = this.bindings.get(name);
        org.jboss.as.network.ManagedSocketFactory factory = this.manager.getSocketFactory();
        return binding != null ? factory.createSocket(binding.getName()) : factory.createSocket();
    }

    public ServerSocket createServerSocket(String name) throws IOException {
        SocketBinding binding = this.bindings.get(name);
        ManagedServerSocketFactory factory = this.manager.getServerSocketFactory();
        return binding != null ? factory.createServerSocket(binding.getName()) : factory.createServerSocket();
    }

    public DatagramSocket createDatagramSocket(String name, SocketAddress bindAddress) throws SocketException {
        SocketBinding binding = this.bindings.get(name);
        if (bindAddress == null) {
            return binding != null ? this.manager.createDatagramSocket(binding.getName()) : this.manager.createDatagramSocket();
        }
        return binding != null ? this.manager.createDatagramSocket(binding.getName(), bindAddress) : this.manager.createDatagramSocket(bindAddress);
    }

    public MulticastSocket createMulticastSocket(String name, SocketAddress bindAddress) throws IOException {
        SocketBinding binding = this.bindings.get(name);
        if (bindAddress == null) {
            return binding != null ? this.manager.createMulticastSocket(binding.getName()) : this.manager.createMulticastSocket();
        }
        return binding != null ? this.manager.createMulticastSocket(binding.getName(), bindAddress) : this.manager.createMulticastSocket(bindAddress);
    }

    public SocketChannel createSocketChannel(String name) throws IOException {
        return this.createNetworkChannel(name, SelectorProvider::openSocketChannel, SocketBindingManager.NamedManagedBindingRegistry::registerChannel, SocketBindingManager.UnnamedBindingRegistry::registerChannel);
    }

    public ServerSocketChannel createServerSocketChannel(String name) throws IOException {
        return this.createNetworkChannel(name, SelectorProvider::openServerSocketChannel, SocketBindingManager.NamedManagedBindingRegistry::registerChannel, SocketBindingManager.UnnamedBindingRegistry::registerChannel);
    }

    public void close(SocketChannel channel) {
        this.closeNetworkChannel(channel);
    }

    public void close(ServerSocketChannel channel) {
        this.closeNetworkChannel(channel);
    }

    private <C extends NetworkChannel> C createNetworkChannel(String name, ExceptionFunction<SelectorProvider, C, IOException> factory, TriFunction<SocketBindingManager.NamedManagedBindingRegistry, String, C, Closeable> namedRegistration, BiFunction<SocketBindingManager.UnnamedBindingRegistry, C, Closeable> unnamedRegistration) throws IOException {
        SocketBinding binding = this.bindings.get(name);
        NetworkChannel channel = (NetworkChannel)factory.apply((Object)this.provider);
        this.channels.put(channel, binding != null ? namedRegistration.apply(this.manager.getNamedRegistry(), binding.getName(), channel) : unnamedRegistration.apply(this.manager.getUnnamedRegistry(), channel));
        return (C)channel;
    }

    private void closeNetworkChannel(NetworkChannel channel) {
        Util.close((Closeable)this.channels.remove(channel));
        Util.close((Closeable)channel);
    }

    private static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

