/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.util.function.Supplier;
import org.jgroups.util.ThreadFactory;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.clustering.context.ThreadContextClassLoaderReference;

public class ClassLoaderThreadFactory
implements ThreadFactory {
    private final ThreadFactory factory;
    private final Contextualizer contextualizer;

    public ClassLoaderThreadFactory(ThreadFactory factory, ClassLoader targetLoader) {
        this.factory = factory;
        this.contextualizer = Contextualizer.withContextProvider((Supplier)ThreadContextClassLoaderReference.CURRENT.provide((Object)targetLoader));
    }

    public Thread newThread(Runnable runner) {
        return this.newThread(runner, null);
    }

    public Thread newThread(Runnable runner, String name) {
        return this.factory.newThread(this.contextualizer.contextualize(runner), name);
    }

    public void setPattern(String pattern) {
        this.factory.setPattern(pattern);
    }

    public void setIncludeClusterName(boolean includeClusterName) {
        this.factory.setIncludeClusterName(includeClusterName);
    }

    public void setClusterName(String channelName) {
        this.factory.setClusterName(channelName);
    }

    public void setAddress(String address) {
        this.factory.setAddress(address);
    }

    public void renameThread(String base_name, Thread thread) {
        this.factory.renameThread(base_name, thread);
    }

    public boolean useVirtualThreads() {
        return this.factory.useVirtualThreads();
    }
}

