/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.Objects;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;

public class NativeProtoStreamTestCase {
    @Test
    public void test() throws IOException {
        ProtoStreamTesterFactory factory = ProtoStreamTesterFactory.INSTANCE;
        factory.createTester(Sex.class).test();
        Employee head = new Employee(1, new Name("Allegra", "Coleman"), Sex.FEMALE, null);
        Employee manager = new Employee(2, new Name("John", "Barron"), Sex.MALE, head);
        Employee employee = new Employee(3, new Name("Alan", "Smithee"), Sex.MALE, manager);
        factory.createTester().test((Object)employee, NativeProtoStreamTestCase::equals);
    }

    static void equals(Employee expected, Employee actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertSame((Object)((Object)expected.getSex()), (Object)((Object)actual.getSex()));
        Assert.assertEquals((Object)expected.isHead(), (Object)actual.isHead());
        if (!expected.isHead()) {
            NativeProtoStreamTestCase.equals(expected.getManager(), actual.getManager());
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={Sex.class, NameFactory.class, Employee.class}, service=false)
    static interface EmployeeInitializer
    extends SerializationContextInitializer {
    }

    @ProtoAdapter(value=Name.class)
    static class NameFactory {
        NameFactory() {
        }

        @ProtoFactory
        static Name create(String first, String last) {
            return new Name(first, last);
        }

        @ProtoField(value=1)
        static String getFirst(Name name) {
            return name.getFirst();
        }

        @ProtoField(value=2)
        static String getLast(Name name) {
            return name.getLast();
        }
    }

    static class Name {
        private final String first;
        private final String last;

        Name(String first, String last) {
            this.first = first;
            this.last = last;
        }

        String getFirst() {
            return this.first;
        }

        String getLast() {
            return this.last;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Name)) {
                return false;
            }
            Name name = (Name)object;
            return Objects.equals(this.first, name.first) && Objects.equals(this.last, name.last);
        }

        public int hashCode() {
            return Objects.hash(this.last, this.first);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.last != null) {
                builder.append(this.last);
                if (this.first != null) {
                    builder.append(", ").append(this.first);
                }
            }
            return builder.toString();
        }
    }

    static class Employee {
        private final Integer id;
        private final Name name;
        private final Sex sex;
        private final Employee manager;

        @ProtoFactory
        Employee(Integer id, Name name, Sex sex, Employee manager) {
            this.id = id;
            this.name = name;
            this.sex = sex;
            this.manager = manager;
        }

        @ProtoField(value=1)
        Integer getId() {
            return this.id;
        }

        @ProtoField(value=2)
        Name getName() {
            return this.name;
        }

        @ProtoField(value=3)
        Sex getSex() {
            return this.sex;
        }

        @ProtoField(value=4)
        Employee getManager() {
            return this.manager;
        }

        boolean isHead() {
            return this.manager == null;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Employee)) {
                return false;
            }
            Employee employee = (Employee)object;
            return Objects.equals(this.id, employee.id);
        }
    }

    static enum Sex {
        MALE,
        FEMALE;

    }
}

