/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;

public class BooleanExternalizer<T>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final Function<Boolean, T> reader;
    private final Function<T, Boolean> writer;

    public BooleanExternalizer(Class<T> targetClass, Function<Boolean, T> reader, Function<T, Boolean> writer) {
        this.targetClass = targetClass;
        this.reader = reader;
        this.writer = writer;
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
        output.writeBoolean(this.writer.apply(object));
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.reader.apply(input.readBoolean());
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

