/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;

public class OptionalIntExternalizer
implements Externalizer<OptionalInt> {
    public void writeObject(ObjectOutput output, OptionalInt value) throws IOException {
        boolean present = value.isPresent();
        output.writeBoolean(present);
        if (present) {
            output.writeInt(value.getAsInt());
        }
    }

    public OptionalInt readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return input.readBoolean() ? OptionalInt.of(input.readInt()) : OptionalInt.empty();
    }

    public OptionalInt size(OptionalInt value) {
        return OptionalInt.of(value.isPresent() ? 5 : 1);
    }

    public Class<OptionalInt> getTargetClass() {
        return OptionalInt.class;
    }
}

