/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.group;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jgroups.Address;
import org.jgroups.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.ExternalizerTester;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.jboss.JBossMarshallingTesterFactory;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.marshalling.spi.Formatter;
import org.wildfly.clustering.marshalling.spi.FormatterTester;
import org.wildfly.clustering.server.infinispan.group.AddressableNode;
import org.wildfly.clustering.server.infinispan.group.AddressableNodeSerializer;

public class AddressableNodeSerializerTestCase {
    private final AddressableNode node = new AddressableNode((Address)UUID.randomUUID(), "foo", new InetSocketAddress(InetAddress.getLoopbackAddress(), Short.MAX_VALUE));

    @Test
    public void test() throws IOException {
        this.test((Tester<AddressableNode>)new ExternalizerTester((Externalizer)new AddressableNodeSerializer.AddressableNodeExternalizer()));
        this.test((Tester<AddressableNode>)new FormatterTester((Formatter)new AddressableNodeSerializer.AddressableNodeFormatter()));
        this.test((Tester<AddressableNode>)JBossMarshallingTesterFactory.INSTANCE.createTester());
        this.test((Tester<AddressableNode>)ProtoStreamTesterFactory.INSTANCE.createTester());
    }

    public void test(Tester<AddressableNode> tester) throws IOException {
        tester.test((Object)this.node, AddressableNodeSerializerTestCase::assertEquals);
    }

    static void assertEquals(AddressableNode expected, AddressableNode actual) {
        Assert.assertEquals((Object)expected.getAddress(), (Object)actual.getAddress());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getSocketAddress(), (Object)actual.getSocketAddress());
    }
}

