/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.msc.DelegatingServiceBuilder;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.clustering.msc.ServiceControllerFactory;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.singleton.SingletonContext;
import org.wildfly.clustering.server.singleton.SingletonValueCommand;
import org.wildfly.clustering.server.singleton.StopSingletonCommand;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.election.SimpleSingletonElectionPolicy;
import org.wildfly.clustering.spi.CacheGroupServiceName;
import org.wildfly.clustering.spi.GroupServiceName;

public class CacheSingletonServiceBuilder<T>
implements SingletonServiceBuilder<T>,
Service<T>,
ServiceProviderRegistration.Listener,
SingletonContext<T>,
Singleton {
    private final InjectedValue<Group> group = new InjectedValue();
    private final InjectedValue<ServiceProviderRegistry> registry = new InjectedValue();
    private final InjectedValue<CommandDispatcherFactory> dispatcherFactory = new InjectedValue();
    private final Service<T> service;
    final ServiceName targetServiceName;
    final ServiceName singletonServiceName;
    private final AtomicBoolean master = new AtomicBoolean(false);
    private final SingletonContext<T> singletonDispatcher = new SingletonDispatcher();
    private final String containerName;
    private final String cacheName;
    volatile ServiceProviderRegistration<ServiceName> registration;
    volatile CommandDispatcher<SingletonContext<T>> dispatcher;
    volatile boolean started = false;
    private volatile SingletonElectionPolicy electionPolicy = new SimpleSingletonElectionPolicy();
    private volatile ServiceRegistry serviceRegistry;
    volatile int quorum = 1;

    public CacheSingletonServiceBuilder(ServiceName serviceName, Service<T> service, String containerName, String cacheName) {
        this.singletonServiceName = serviceName;
        this.targetServiceName = serviceName.append(new String[]{"service"});
        this.service = service;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceName getServiceName() {
        return this.singletonServiceName;
    }

    public ServiceBuilder<T> build(ServiceTarget target) {
        ServiceBuilder serviceBuilder = target.addService(this.targetServiceName, this.service).setInitialMode(ServiceController.Mode.NEVER);
        AbstractServiceListener listener = new AbstractServiceListener<T>(){

            public void serviceRemoveRequested(ServiceController<? extends T> controller) {
                ServiceController service = controller.getServiceContainer().getService(CacheSingletonServiceBuilder.this.targetServiceName);
                if (service != null) {
                    service.setMode(ServiceController.Mode.REMOVE);
                    controller.removeListener((ServiceListener)this);
                }
            }
        };
        final ServiceBuilder singletonBuilder = new AsynchronousServiceBuilder(this.singletonServiceName, (Service)this).build(target).addAliases(new ServiceName[]{this.singletonServiceName.append(new String[]{"singleton"})}).addDependency(CacheGroupServiceName.GROUP.getServiceName(this.containerName, this.cacheName), Group.class, this.group).addDependency(CacheGroupServiceName.SERVICE_PROVIDER_REGISTRY.getServiceName(this.containerName, this.cacheName), ServiceProviderRegistry.class, this.registry).addDependency(GroupServiceName.COMMAND_DISPATCHER.getServiceName(this.containerName), CommandDispatcherFactory.class, this.dispatcherFactory).addListener((ServiceListener)listener);
        return new DelegatingServiceBuilder<T>(serviceBuilder, ServiceControllerFactory.SIMPLE){

            public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
                singletonBuilder.addAliases(aliases);
                return this;
            }

            public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
                singletonBuilder.setInitialMode(mode);
                return this;
            }

            public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
                singletonBuilder.addMonitor(monitor);
                return this;
            }

            public ServiceBuilder<T> addMonitors(StabilityMonitor ... monitors) {
                singletonBuilder.addMonitors(monitors);
                return this;
            }

            public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
                singletonBuilder.addListener(listener);
                return this;
            }

            public ServiceBuilder<T> addListener(ServiceListener<? super T> ... listeners) {
                singletonBuilder.addListener(listeners);
                return this;
            }

            public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> listeners) {
                singletonBuilder.addListener(listeners);
                return this;
            }

            public ServiceController<T> install() {
                super.install();
                return singletonBuilder.install();
            }
        };
    }

    public SingletonServiceBuilder<T> requireQuorum(int quorum) {
        this.quorum = quorum;
        return this;
    }

    public SingletonServiceBuilder<T> electionPolicy(SingletonElectionPolicy electionPolicy) {
        this.electionPolicy = electionPolicy;
        return this;
    }

    public void start(StartContext context) {
        this.serviceRegistry = context.getController().getServiceContainer();
        this.dispatcher = ((CommandDispatcherFactory)this.dispatcherFactory.getValue()).createCommandDispatcher((Object)this.singletonServiceName, (Object)this);
        ServiceProviderRegistry registry = (ServiceProviderRegistry)this.registry.getValue();
        this.registration = registry.register((Object)this.singletonServiceName, (ServiceProviderRegistration.Listener)this);
        this.started = true;
    }

    public void stop(StopContext context) {
        this.started = false;
        this.registration.close();
        this.dispatcher.close();
    }

    public boolean isMaster() {
        return this.master.get();
    }

    public void providersChanged(Set<Node> nodes) {
        if (this.elected(nodes)) {
            if (!this.master.get()) {
                ClusteringServerLogger.ROOT_LOGGER.electedMaster(this.singletonServiceName.getCanonicalName());
                this.singletonDispatcher.stopOldMaster();
                this.startNewMaster();
            }
        } else if (this.master.get()) {
            ClusteringServerLogger.ROOT_LOGGER.electedSlave(this.singletonServiceName.getCanonicalName());
            this.stopOldMaster();
        }
    }

    private boolean elected(Set<Node> candidates) {
        Node elected;
        int size = candidates.size();
        if (size < this.quorum) {
            ClusteringServerLogger.ROOT_LOGGER.quorumNotReached(this.singletonServiceName.getCanonicalName(), this.quorum);
            return false;
        }
        if (size == this.quorum) {
            ClusteringServerLogger.ROOT_LOGGER.quorumJustReached(this.singletonServiceName.getCanonicalName(), this.quorum);
        }
        if ((elected = this.election(candidates)) != null) {
            ClusteringServerLogger.ROOT_LOGGER.elected(elected.getName(), this.singletonServiceName.getCanonicalName());
        }
        return elected != null ? elected.equals(((Group)this.group.getValue()).getLocalNode()) : false;
    }

    private Node election(Set<Node> candidates) {
        SingletonElectionPolicy policy = this.electionPolicy;
        List nodes = ((Group)this.group.getValue()).getNodes();
        nodes.retainAll(candidates);
        return !nodes.isEmpty() ? policy.elect(nodes) : null;
    }

    private void startNewMaster() {
        this.master.set(true);
        ServiceController service = this.serviceRegistry.getRequiredService(this.targetServiceName);
        try {
            ServiceContainerHelper.start((ServiceController)service);
        }
        catch (StartException e) {
            ClusteringServerLogger.ROOT_LOGGER.serviceStartFailed(e, this.targetServiceName.getCanonicalName());
            ServiceContainerHelper.stop((ServiceController)service);
        }
    }

    public T getValue() {
        if (!this.started) {
            throw new IllegalStateException();
        }
        AtomicReference<T> ref = this.getValueRef();
        if (ref == null) {
            ref = this.singletonDispatcher.getValueRef();
        }
        return ref.get();
    }

    @Override
    public AtomicReference<T> getValueRef() {
        return this.master.get() ? new AtomicReference<Object>(this.service.getValue()) : null;
    }

    @Override
    public void stopOldMaster() {
        if (this.master.compareAndSet(true, false)) {
            ServiceContainerHelper.stop((ServiceController)this.serviceRegistry.getRequiredService(this.targetServiceName));
        }
    }

    class SingletonDispatcher
    implements SingletonContext<T> {
        SingletonDispatcher() {
        }

        @Override
        public void stopOldMaster() {
            try {
                CacheSingletonServiceBuilder.this.dispatcher.executeOnCluster(new StopSingletonCommand(), new Node[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public AtomicReference<T> getValueRef() {
            try {
                Map results = Collections.emptyMap();
                while (results.isEmpty()) {
                    if (!CacheSingletonServiceBuilder.this.started) {
                        throw new IllegalStateException(ClusteringServerLogger.ROOT_LOGGER.notStarted(CacheSingletonServiceBuilder.this.singletonServiceName.getCanonicalName()));
                    }
                    results = CacheSingletonServiceBuilder.this.dispatcher.executeOnCluster(new SingletonValueCommand(), new Node[0]);
                    Iterator responses = results.values().iterator();
                    while (responses.hasNext()) {
                        if (((CommandResponse)responses.next()).get() != null) continue;
                        responses.remove();
                    }
                    int count = results.size();
                    if (count > 1) {
                        throw ClusteringServerLogger.ROOT_LOGGER.unexpectedResponseCount(CacheSingletonServiceBuilder.this.singletonServiceName.getCanonicalName(), count);
                    }
                    if (count != 0) continue;
                    ClusteringServerLogger.ROOT_LOGGER.noResponseFromMaster(CacheSingletonServiceBuilder.this.singletonServiceName.getCanonicalName());
                    if (CacheSingletonServiceBuilder.this.registration.getProviders().size() < CacheSingletonServiceBuilder.this.quorum) {
                        return new AtomicReference();
                    }
                    Thread.yield();
                }
                return (AtomicReference)((CommandResponse)results.values().iterator().next()).get();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

