/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.provider.AbstractServiceProviderRegistration;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.provider.GetLocalServicesCommand;

@Listener
public class CacheServiceProviderRegistry<T>
implements ServiceProviderRegistry<T>,
Group.Listener,
AutoCloseable {
    final ConcurrentMap<T, ServiceProviderRegistration.Listener> listeners = new ConcurrentHashMap<T, ServiceProviderRegistration.Listener>();
    final Batcher<? extends Batch> batcher;
    final Cache<T, Set<Node>> cache;
    private final Group group;
    private final CommandDispatcher<Set<T>> dispatcher;

    public CacheServiceProviderRegistry(CacheServiceProviderRegistryConfiguration<T> config) {
        this.group = config.getGroup();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.dispatcher = config.getCommandDispatcherFactory().createCommandDispatcher(config.getId(), this.listeners.keySet());
        this.cache.addListener((Object)this);
        this.group.addListener((Group.Listener)this);
    }

    @Override
    public void close() {
        this.group.removeListener((Group.Listener)this);
        this.cache.removeListener((Object)this);
        this.dispatcher.close();
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T> register(T service) {
        return this.register(service, null);
    }

    public ServiceProviderRegistration<T> register(final T service, ServiceProviderRegistration.Listener listener) {
        if (this.listeners.putIfAbsent(service, listener) != null) {
            throw new IllegalArgumentException(service.toString());
        }
        Node node = this.group.getLocalNode();
        HashSet<Node> nodes = new HashSet<Node>(Collections.singleton(node));
        try (Batch batch = this.batcher.createBatch();){
            Set existing = (Set)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent(service, nodes);
            if (existing != null && existing.add(node)) {
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)existing);
            }
        }
        return new AbstractServiceProviderRegistration<T>(service, this){

            public void close() {
                Node node = CacheServiceProviderRegistry.this.getGroup().getLocalNode();
                try (Batch batch = CacheServiceProviderRegistry.this.batcher.createBatch();){
                    Set nodes = (Set)CacheServiceProviderRegistry.this.cache.get(service);
                    if (nodes != null && nodes.remove(node)) {
                        AdvancedCache cache = CacheServiceProviderRegistry.this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
                        if (nodes.isEmpty()) {
                            cache.remove(service);
                        } else {
                            cache.replace(service, (Object)nodes);
                        }
                    }
                }
                CacheServiceProviderRegistry.this.listeners.remove(service);
            }
        };
    }

    public Set<Node> getProviders(T service) {
        Set nodes = (Set)this.cache.get(service);
        return nodes != null ? Collections.unmodifiableSet(nodes) : Collections.emptySet();
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    public void membershipChanged(List<Node> previousMembers, List<Node> members, boolean merged) {
        if (this.getGroup().isCoordinator()) {
            HashSet<Node> deadNodes = new HashSet<Node>(previousMembers);
            deadNodes.removeAll(members);
            HashSet<Node> newNodes = new HashSet<Node>(members);
            newNodes.removeAll(previousMembers);
            try (Batch batch = this.batcher.createBatch();){
                if (!deadNodes.isEmpty()) {
                    try (CloseableIterator entries = this.cache.entrySet().iterator();){
                        while (entries.hasNext()) {
                            Map.Entry entry = (Map.Entry)entries.next();
                            Set nodes = (Set)entry.getValue();
                            if (!nodes.removeAll(deadNodes)) continue;
                            entry.setValue(nodes);
                        }
                    }
                }
                if (merged) {
                    for (Node node : newNodes) {
                        List<T> services = this.getServices(node);
                        for (T service : services) {
                            HashSet<Node> nodes = new HashSet<Node>(Collections.singleton(node));
                            Set existing = (Set)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent(service, nodes);
                            if (existing == null || !existing.add(node)) continue;
                            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)existing);
                        }
                    }
                }
            }
        }
    }

    @CacheEntryCreated
    @CacheEntryModified
    public void modified(CacheEntryEvent<ServiceName, Set<Node>> event) {
        if (event.isPre()) {
            return;
        }
        ServiceProviderRegistration.Listener listener = (ServiceProviderRegistration.Listener)this.listeners.get(event.getKey());
        if (listener != null) {
            listener.providersChanged((Set)event.getValue());
        }
    }

    List<T> getServices(Node node) {
        try {
            return (List)this.dispatcher.executeOnNode(new GetLocalServicesCommand(), node).get();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

