/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.provider.AbstractServiceProviderRegistration;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.provider.GetLocalServicesCommand;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;
import org.wildfly.clustering.service.concurrent.StampedLockServiceExecutor;

@Listener(sync=false)
public class CacheServiceProviderRegistry<T>
implements ServiceProviderRegistry<T>,
Group.Listener,
AutoCloseable {
    final ConcurrentMap<T, ServiceProviderRegistration.Listener> listeners = new ConcurrentHashMap<T, ServiceProviderRegistration.Listener>();
    final Batcher<? extends Batch> batcher;
    final Cache<T, Set<Node>> cache;
    private final Group group;
    private final CommandDispatcher<Set<T>> dispatcher;
    private final ServiceExecutor executor = new StampedLockServiceExecutor();

    public CacheServiceProviderRegistry(CacheServiceProviderRegistryConfiguration<T> config) {
        this.group = config.getGroup();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.dispatcher = config.getCommandDispatcherFactory().createCommandDispatcher(config.getId(), this.listeners.keySet());
        this.cache.addListener((Object)this);
        this.group.addListener((Group.Listener)this);
    }

    @Override
    public void close() {
        this.executor.close(() -> {
            this.group.removeListener((Group.Listener)this);
            this.cache.removeListener((Object)this);
            this.dispatcher.close();
        });
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T> register(T service) {
        return this.register(service, null);
    }

    public ServiceProviderRegistration<T> register(final T service, ServiceProviderRegistration.Listener listener) {
        if (this.listeners.putIfAbsent(service, listener) != null) {
            throw new IllegalArgumentException(service.toString());
        }
        try (Batch batch = this.batcher.createBatch();){
            this.register(this.group.getLocalNode(), service);
        }
        return new AbstractServiceProviderRegistration<T>(service, this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                Node node = CacheServiceProviderRegistry.this.getGroup().getLocalNode();
                try (Batch batch = CacheServiceProviderRegistry.this.batcher.createBatch();){
                    Set nodes = (Set)CacheServiceProviderRegistry.this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get(service);
                    if (nodes != null && nodes.remove(node)) {
                        AdvancedCache cache = CacheServiceProviderRegistry.this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
                        if (nodes.isEmpty()) {
                            cache.remove(service);
                        } else {
                            cache.replace(service, (Object)nodes);
                        }
                    }
                }
                finally {
                    CacheServiceProviderRegistry.this.listeners.remove(service);
                }
            }
        };
    }

    void register(Node node, T service) {
        ConcurrentHashSet nodes = new ConcurrentHashSet();
        nodes.add(node);
        Set existing = (Set)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent(service, (Object)nodes);
        if (existing != null && existing.add(node)) {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)existing);
        }
    }

    public Set<Node> getProviders(T service) {
        Set nodes = (Set)this.cache.get(service);
        return nodes != null ? Collections.unmodifiableSet(nodes) : Collections.emptySet();
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    public void membershipChanged(List<Node> previousMembers, List<Node> members, boolean merged) {
        if (this.getGroup().isCoordinator()) {
            this.executor.execute(() -> {
                Throwable throwable;
                Batch batch;
                HashSet deadNodes = new HashSet(previousMembers);
                deadNodes.removeAll(members);
                HashSet newNodes = new HashSet(members);
                newNodes.removeAll(previousMembers);
                if (!deadNodes.isEmpty()) {
                    batch = this.batcher.createBatch();
                    throwable = null;
                    try (CloseableIterator entries = this.cache.entrySet().iterator();){
                        while (entries.hasNext()) {
                            Map.Entry entry = (Map.Entry)entries.next();
                            Set nodes = (Set)entry.getValue();
                            if (!nodes.removeAll(deadNodes)) continue;
                            entry.setValue(nodes);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (batch != null) {
                            if (throwable != null) {
                                try {
                                    batch.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                batch.close();
                            }
                        }
                    }
                }
                if (merged) {
                    batch = this.batcher.createBatch();
                    throwable = null;
                    try {
                        for (Node node : newNodes) {
                            for (T service : this.getServices(node)) {
                                this.register(node, service);
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (batch != null) {
                            if (throwable != null) {
                                try {
                                    batch.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                batch.close();
                            }
                        }
                    }
                }
            });
        }
    }

    @CacheEntryCreated
    @CacheEntryModified
    public void modified(CacheEntryEvent<ServiceName, Set<Node>> event) {
        if (event.isPre()) {
            return;
        }
        ServiceProviderRegistration.Listener listener = (ServiceProviderRegistration.Listener)this.listeners.get(event.getKey());
        if (listener != null) {
            listener.providersChanged((Set)event.getValue());
        }
    }

    List<T> getServices(Node node) {
        try {
            return (List)this.dispatcher.executeOnNode(new GetLocalServicesCommand(), node).get();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

