/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.group.InfinispanNodeFactory;
import org.wildfly.clustering.server.registry.CacheRegistryFactory;
import org.wildfly.clustering.server.registry.CacheRegistryFactoryConfiguration;
import org.wildfly.clustering.server.registry.RegistryFactoryServiceNameProvider;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupServiceName;

public class CacheRegistryFactoryBuilder<K, V>
extends RegistryFactoryServiceNameProvider
implements Builder<RegistryFactory<K, V>>,
Value<RegistryFactory<K, V>>,
CacheRegistryFactoryConfiguration<K, V> {
    private final InjectedValue<Group> group = new InjectedValue();
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<InfinispanNodeFactory> factory = new InjectedValue();

    public CacheRegistryFactoryBuilder(String containerName, String cacheName) {
        super(containerName, cacheName);
    }

    public ServiceBuilder<RegistryFactory<K, V>> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder(this.getServiceName(), (Service)new ValueService((Value)this)).build(target).addDependency(CacheGroupServiceName.NODE_FACTORY.getServiceName(this.containerName, this.cacheName), InfinispanNodeFactory.class, this.factory).addDependency(CacheGroupServiceName.GROUP.getServiceName(this.containerName, this.cacheName), Group.class, this.group).addDependency(CacheServiceName.CACHE.getServiceName(this.containerName, this.cacheName), Cache.class, this.cache).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public RegistryFactory<K, V> getValue() {
        return new CacheRegistryFactory(this);
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public Batcher<? extends Batch> getBatcher() {
        return new InfinispanBatcher(this.getCache());
    }

    @Override
    public Group getGroup() {
        return (Group)this.group.getValue();
    }

    @Override
    public Cache<Node, Map.Entry<K, V>> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.factory.getValue();
    }
}

