package org.wildfly.clustering.server.logging;

import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.wildfly.clustering.group.Node;
import java.lang.String;
import org.jboss.logging.Logger;
import org.infinispan.notifications.cachelistener.event.Event.Type;
import java.util.Collection;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.util.Arrays;
import java.util.Map;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2016-08-18T19:09:12-0500")
public class ClusteringServerLogger_$logger implements ClusteringServerLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ClusteringServerLogger_$logger.class.getName();
    public ClusteringServerLogger_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    @Override
    public final void startSingleton(final String service) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, startSingleton$str(), service);
    }
    private static final String startSingleton = "WFLYCLSV0001: This node will now operate as the singleton provider of the %s service";
    protected String startSingleton$str() {
        return startSingleton;
    }
    @Override
    public final void stopSingleton(final String service) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, stopSingleton$str(), service);
    }
    private static final String stopSingleton = "WFLYCLSV0002: This node will no longer operate as the singleton provider of the %s service";
    protected String stopSingleton$str() {
        return stopSingleton;
    }
    @Override
    public final void elected(final String node, final String service) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.INFO, null, elected$str(), node, service);
    }
    private static final String elected = "WFLYCLSV0003: %s elected as the singleton provider of the %s service";
    protected String elected$str() {
        return elected;
    }
    @Override
    public final void noResponseFromMaster(final String service) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, noResponseFromMaster$str(), service);
    }
    private static final String noResponseFromMaster = "WFLYCLSV0004: No response received from master node of the %s service, retrying...";
    protected String noResponseFromMaster$str() {
        return noResponseFromMaster;
    }
    @Override
    public final void serviceStartFailed(final StartException e, final String service) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, serviceStartFailed$str(), service);
    }
    private static final String serviceStartFailed = "WFLYCLSV0005: Failed to start %s service";
    protected String serviceStartFailed$str() {
        return serviceStartFailed;
    }
    @Override
    public final void quorumNotReached(final String service, final int quorum) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, null, quorumNotReached$str(), service, quorum);
    }
    private static final String quorumNotReached = "WFLYCLSV0006: Failed to reach quorum of %2$d for %1$s service. No singleton master will be elected.";
    protected String quorumNotReached$str() {
        return quorumNotReached;
    }
    @Override
    public final void quorumJustReached(final String service, final int quorum) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, quorumJustReached$str(), service, quorum);
    }
    private static final String quorumJustReached = "WFLYCLSV0007: Just reached required quorum of %2$d for %1$s service. If this cluster loses another member, no node will be chosen to provide this service.";
    protected String quorumJustReached$str() {
        return quorumJustReached;
    }
    private static final String unexpectedResponseCount = "WFLYCLSV0008: Expected service %s value from singleton master only, but instead received %d results.";
    protected String unexpectedResponseCount$str() {
        return unexpectedResponseCount;
    }
    @Override
    public final IllegalStateException unexpectedResponseCount(final String serviceName, final int results) {
        final IllegalStateException result = new IllegalStateException(String.format(unexpectedResponseCount$str(), serviceName, results));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notStarted = "WFLYCLSV0009: Singleton service %s is not started.";
    protected String notStarted$str() {
        return notStarted;
    }
    @Override
    public final IllegalStateException notStarted(final String serviceName) {
        final IllegalStateException result = new IllegalStateException(String.format(notStarted$str(), serviceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void registryPurgeFailed(final CacheException e, final String containerName, final String cacheName, final Collection<Node> nodes) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, e, registryPurgeFailed$str(), containerName, cacheName, nodes);
    }
    private static final String registryPurgeFailed = "WFLYCLSV0010: Failed to purge %s/%s registry of old registry entries for: %s";
    protected String registryPurgeFailed$str() {
        return registryPurgeFailed;
    }
    @Override
    public final void registryListenerFailed(final Throwable e, final String containerName, final String cacheName, final Type type, final Map<? extends Object, ? extends Object> entries) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, e, registryListenerFailed$str(), containerName, cacheName, type, entries);
    }
    private static final String registryListenerFailed = "WFLYCLSV0011: Failed to notify %s/%s registry listener of %s(%s) event";
    protected String registryListenerFailed$str() {
        return registryListenerFailed;
    }
    @Override
    public final void serviceProviderRegistrationListenerFailed(final Throwable e, final String containerName, final String cacheName, final Set<Node> providers) {
        log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, e, serviceProviderRegistrationListenerFailed$str(), containerName, cacheName, providers);
    }
    private static final String serviceProviderRegistrationListenerFailed = "WFLYCLSV0012: Failed to notify %s/%s service provider registration listener of new providers: %s";
    protected String serviceProviderRegistrationListenerFailed$str() {
        return serviceProviderRegistrationListenerFailed;
    }
}
