/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.Optional;
import java.util.stream.Stream;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.singleton.DistributedSingletonService;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceBuilderContext;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceContext;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.election.SimpleSingletonElectionPolicy;

public class DistributedSingletonServiceBuilder<T>
implements SingletonServiceBuilder<T>,
DistributedSingletonServiceContext<T> {
    private final ValueDependency<ServiceProviderRegistry> registry;
    private final ValueDependency<CommandDispatcherFactory> dispatcherFactory;
    private final ServiceName serviceName;
    private final Service<T> primaryService;
    private final Optional<Service<T>> backupService;
    private volatile SingletonElectionPolicy electionPolicy = new SimpleSingletonElectionPolicy();
    private volatile int quorum = 1;

    public DistributedSingletonServiceBuilder(DistributedSingletonServiceBuilderContext context, ServiceName serviceName, Service<T> primaryService, Service<T> backupService) {
        this.registry = context.getServiceProviderRegistryDependency();
        this.dispatcherFactory = context.getCommandDispatcherFactoryDependency();
        this.serviceName = serviceName;
        this.primaryService = primaryService;
        this.backupService = Optional.ofNullable(backupService);
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public ServiceBuilder<T> build(ServiceTarget target) {
        DistributedSingletonService service = new DistributedSingletonService(this);
        ServiceBuilder installer = target.addService(this.serviceName, service);
        Stream.of(this.registry, this.dispatcherFactory).forEach(dependency -> dependency.register(installer));
        return installer;
    }

    public SingletonServiceBuilder<T> requireQuorum(int quorum) {
        if (quorum < 1) {
            throw ClusteringServerLogger.ROOT_LOGGER.invalidQuorum(quorum);
        }
        this.quorum = quorum;
        return this;
    }

    public SingletonServiceBuilder<T> electionPolicy(SingletonElectionPolicy electionPolicy) {
        this.electionPolicy = electionPolicy;
        return this;
    }

    @Override
    public Value<ServiceProviderRegistry> getServiceProviderRegistry() {
        return this.registry;
    }

    @Override
    public Value<CommandDispatcherFactory> getCommandDispatcherFactory() {
        return this.dispatcherFactory;
    }

    @Override
    public Service<T> getPrimaryService() {
        return this.primaryService;
    }

    @Override
    public Optional<Service<T>> getBackupService() {
        return this.backupService;
    }

    @Override
    public SingletonElectionPolicy getElectionPolicy() {
        return this.electionPolicy;
    }

    @Override
    public int getQuorum() {
        return this.quorum;
    }
}

