/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.clustering.function.Functions;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.Services;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.JChannel;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.server.dispatcher.AutoCloseableCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.ManagedCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.MarshallingConfigurationContext;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;

public class ChannelCommandDispatcherFactoryBuilder
implements CapabilityServiceBuilder<CommandDispatcherFactory>,
ChannelCommandDispatcherFactoryConfiguration,
MarshallingConfigurationContext {
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final ServiceName name;
    private final String group;
    private volatile ValueDependency<ChannelFactory> channelFactory;
    private volatile ValueDependency<JChannel> channel;
    private volatile ValueDependency<Module> module;
    private volatile long timeout = TimeUnit.MINUTES.toMillis(1L);

    public ChannelCommandDispatcherFactoryBuilder(ServiceName name, String group) {
        this.name = name;
        this.group = group;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<CommandDispatcherFactory> configure(CapabilityServiceSupport support) {
        this.channel = new InjectedValueDependency(JGroupsRequirement.CHANNEL.getServiceName(support, this.group), JChannel.class);
        this.channelFactory = new InjectedValueDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(support, this.group), ChannelFactory.class);
        this.module = new InjectedValueDependency(JGroupsRequirement.CHANNEL_MODULE.getServiceName(support, this.group), Module.class);
        return this;
    }

    public ServiceBuilder<CommandDispatcherFactory> build(ServiceTarget target) {
        Supplier<AutoCloseableCommandDispatcherFactory> supplier = () -> new ManagedCommandDispatcherFactory(new ChannelCommandDispatcherFactory(this));
        SuppliedValueService service = new SuppliedValueService(Functions.identity(), supplier, Consumers.close());
        ServiceBuilder builder = new AsynchronousServiceBuilder(this.name, (Service)service).build(target).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).setInitialMode(ServiceController.Mode.PASSIVE);
        Stream.of(this.channel, this.channelFactory, this.module).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    public ChannelCommandDispatcherFactoryBuilder timeout(long value, TimeUnit unit) {
        this.timeout = unit.toMillis(value);
        return this;
    }

    @Override
    public Module getModule() {
        return (Module)this.module.getValue();
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return (ModuleLoader)this.loader.getValue();
    }

    @Override
    public JChannel getChannel() {
        return (JChannel)this.channel.getValue();
    }

    @Override
    public MarshallingContext getMarshallingContext() {
        return new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)this), (ClassLoader)this.getModule().getClassLoader());
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public ChannelFactory getChannelFactory() {
        return (ChannelFactory)this.channelFactory.getValue();
    }

    static enum MarshallingVersion implements Function<MarshallingConfigurationContext, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)context.getModuleLoader()));
                config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)context.getModule().getClassLoader()));
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)context.getModuleLoader()));
                config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)context.getModule().getClassLoader()));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable((ClassLoader)context.getModule().getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

