package org.wildfly.clustering.server.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.infinispan.notifications.cachelistener.event.Event.Type;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-05-17T15:05:39-0700")
public class ClusteringServerLogger_$logger extends DelegatingBasicLogger implements ClusteringServerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ClusteringServerLogger_$logger.class.getName();
    public ClusteringServerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void startSingleton(final String service) {
        super.log.logf(FQCN, INFO, null, startSingleton$str(), service);
    }
    private static final String startSingleton = "WFLYCLSV0001: This node will now operate as the singleton provider of the %s service";
    protected String startSingleton$str() {
        return startSingleton;
    }
    @Override
    public final void stopSingleton(final String service) {
        super.log.logf(FQCN, INFO, null, stopSingleton$str(), service);
    }
    private static final String stopSingleton = "WFLYCLSV0002: This node will no longer operate as the singleton provider of the %s service";
    protected String stopSingleton$str() {
        return stopSingleton;
    }
    @Override
    public final void elected(final String node, final String service) {
        super.log.logf(FQCN, INFO, null, elected$str(), node, service);
    }
    private static final String elected = "WFLYCLSV0003: %s elected as the singleton provider of the %s service";
    protected String elected$str() {
        return elected;
    }
    private static final String noResponseFromMaster = "WFLYCLSV0004: No response received from master node of the %s service, retrying...";
    protected String noResponseFromMaster$str() {
        return noResponseFromMaster;
    }
    @Override
    public final IllegalStateException noResponseFromMaster(final String service) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noResponseFromMaster$str(), service));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void serviceStartFailed(final StartException e, final String service) {
        super.log.logf(FQCN, ERROR, e, serviceStartFailed$str(), service);
    }
    private static final String serviceStartFailed = "WFLYCLSV0005: Failed to start %s service";
    protected String serviceStartFailed$str() {
        return serviceStartFailed;
    }
    @Override
    public final void quorumNotReached(final String service, final int quorum) {
        super.log.logf(FQCN, WARN, null, quorumNotReached$str(), service, quorum);
    }
    private static final String quorumNotReached = "WFLYCLSV0006: Failed to reach quorum of %2$d for %1$s service. No singleton master will be elected.";
    protected String quorumNotReached$str() {
        return quorumNotReached;
    }
    @Override
    public final void quorumJustReached(final String service, final int quorum) {
        super.log.logf(FQCN, INFO, null, quorumJustReached$str(), service, quorum);
    }
    private static final String quorumJustReached = "WFLYCLSV0007: Just reached required quorum of %2$d for %1$s service. If this cluster loses another member, no node will be chosen to provide this service.";
    protected String quorumJustReached$str() {
        return quorumJustReached;
    }
    private static final String multiplePrimaryProvidersDetected = "WFLYCLSV0008: Detected multiple primary providers for %s service: %s";
    protected String multiplePrimaryProvidersDetected$str() {
        return multiplePrimaryProvidersDetected;
    }
    @Override
    public final IllegalArgumentException multiplePrimaryProvidersDetected(final String serviceName, final java.util.Collection<org.wildfly.clustering.group.Node> nodes) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), multiplePrimaryProvidersDetected$str(), serviceName, nodes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notStarted = "WFLYCLSV0009: Singleton service %s is not started.";
    protected String notStarted$str() {
        return notStarted;
    }
    @Override
    public final IllegalStateException notStarted(final String serviceName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notStarted$str(), serviceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void registryPurgeFailed(final Throwable e, final String containerName, final String cacheName, final java.util.Collection<?> members) {
        super.log.logf(FQCN, WARN, e, registryPurgeFailed$str(), containerName, cacheName, members);
    }
    private static final String registryPurgeFailed = "WFLYCLSV0010: Failed to purge %s/%s registry of old registry entries for: %s";
    protected String registryPurgeFailed$str() {
        return registryPurgeFailed;
    }
    @Override
    public final void registryListenerFailed(final Throwable e, final String containerName, final String cacheName, final Type type, final java.util.Map<?, ?> entries) {
        super.log.logf(FQCN, WARN, e, registryListenerFailed$str(), containerName, cacheName, type, entries);
    }
    private static final String registryListenerFailed = "WFLYCLSV0011: Failed to notify %s/%s registry listener of %s(%s) event";
    protected String registryListenerFailed$str() {
        return registryListenerFailed;
    }
    @Override
    public final void serviceProviderRegistrationListenerFailed(final Throwable e, final String containerName, final String cacheName, final java.util.Set<org.wildfly.clustering.group.Node> providers) {
        super.log.logf(FQCN, WARN, e, serviceProviderRegistrationListenerFailed$str(), containerName, cacheName, providers);
    }
    private static final String serviceProviderRegistrationListenerFailed = "WFLYCLSV0012: Failed to notify %s/%s service provider registration listener of new providers: %s";
    protected String serviceProviderRegistrationListenerFailed$str() {
        return serviceProviderRegistrationListenerFailed;
    }
    @Override
    public final void noPrimaryElected(final String service) {
        super.log.logf(FQCN, WARN, null, noPrimaryElected$str(), service);
    }
    private static final String noPrimaryElected = "WFLYCLSV0013: No node was elected as the singleton provider of the %s service";
    protected String noPrimaryElected$str() {
        return noPrimaryElected;
    }
    private static final String invalidQuorum = "WFLYCLSV0014: Specified quorum %d must be greater than zero";
    protected String invalidQuorum$str() {
        return invalidQuorum;
    }
    @Override
    public final IllegalArgumentException invalidQuorum(final int quorum) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidQuorum$str(), quorum));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToRestoreLocalRegistryEntry(final Throwable cause, final String containerName, final String cacheName) {
        super.log.logf(FQCN, WARN, cause, failedToRestoreLocalRegistryEntry$str(), containerName, cacheName);
    }
    private static final String failedToRestoreLocalRegistryEntry = "WFLYCLSV0015: Failed to restore local %s/%s registry entry following network partititon merge";
    protected String failedToRestoreLocalRegistryEntry$str() {
        return failedToRestoreLocalRegistryEntry;
    }
    private static final String commandDispatcherAlreadyExists = "WFLYCLSV0016: A command dispatcher already exists for %s";
    protected String commandDispatcherAlreadyExists$str() {
        return commandDispatcherAlreadyExists;
    }
    @Override
    public final IllegalArgumentException commandDispatcherAlreadyExists(final Object id) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), commandDispatcherAlreadyExists$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String commandDispatcherContextMismatch = "WFLYCLSV0017: A command dispatcher for %s already exists, but with a different command context";
    protected String commandDispatcherContextMismatch$str() {
        return commandDispatcherContextMismatch;
    }
    @Override
    public final IllegalArgumentException commandDispatcherContextMismatch(final Object id) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), commandDispatcherContextMismatch$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
