/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Buffer;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.dispatcher.CommandMarshaller;
import org.wildfly.clustering.server.dispatcher.NoSuchService;
import org.wildfly.clustering.server.dispatcher.ServiceRequest;
import org.wildfly.clustering.server.group.Group;

public class ChannelCommandDispatcher<C>
implements CommandDispatcher<C> {
    private static final RspFilter FILTER = new RspFilter(){

        public boolean isAcceptable(Object response, Address sender) {
            return !(response instanceof NoSuchService);
        }

        public boolean needMoreResponses() {
            return true;
        }
    };
    private final MessageDispatcher dispatcher;
    private final CommandMarshaller<C> marshaller;
    private final Group<Address> group;
    private final Duration timeout;
    private final CommandDispatcher<C> localDispatcher;
    private final Runnable closeTask;
    private final Address localAddress;
    private final RequestOptions options;

    public ChannelCommandDispatcher(MessageDispatcher dispatcher, CommandMarshaller<C> marshaller, Group<Address> group, Duration timeout, CommandDispatcher<C> localDispatcher, Runnable closeTask) {
        this.dispatcher = dispatcher;
        this.marshaller = marshaller;
        this.group = group;
        this.timeout = timeout;
        this.localDispatcher = localDispatcher;
        this.closeTask = closeTask;
        this.localAddress = dispatcher.getChannel().getAddress();
        this.options = new RequestOptions(ResponseMode.GET_ALL, this.timeout.toMillis(), false, FILTER, new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    }

    public C getContext() {
        return (C)this.localDispatcher.getContext();
    }

    public void close() {
        this.closeTask.run();
    }

    public <R> CompletionStage<R> executeOnMember(Command<R, ? super C> command, Node member) throws CommandDispatcherException {
        Address address = (Address)this.group.getAddress(member);
        if (this.localAddress.equals(address)) {
            return this.localDispatcher.executeOnMember(command, member);
        }
        Buffer buffer = this.createBuffer(command);
        ServiceRequest request = new ServiceRequest(this.dispatcher.getCorrelator(), (Address)this.group.getAddress(member), this.options);
        return request.send(buffer);
    }

    public <R> Map<Node, CompletionStage<R>> executeOnGroup(Command<R, ? super C> command, Node ... excludedMembers) throws CommandDispatcherException {
        HashSet<Node> excluded = excludedMembers != null ? new HashSet<Node>(Arrays.asList(excludedMembers)) : Collections.emptySet();
        ConcurrentHashMap results = new ConcurrentHashMap();
        Buffer buffer = this.createBuffer(command);
        for (Node member : this.group.getMembership().getMembers()) {
            if (excluded.contains(member)) continue;
            Address address = (Address)this.group.getAddress(member);
            if (this.localAddress.equals(address)) {
                results.put(member, this.localDispatcher.executeOnMember(command, member));
                continue;
            }
            try {
                ServiceRequest request = new ServiceRequest(this.dispatcher.getCorrelator(), (Address)this.group.getAddress(member), this.options);
                CompletionStage future = request.send(buffer);
                results.put(member, future);
                future.whenComplete(new PruneCancellationTask(results, member));
            }
            catch (CommandDispatcherException e) {
                for (CompletionStage result : results.values()) {
                    result.toCompletableFuture().cancel(true);
                }
                throw e;
            }
        }
        return results;
    }

    private <R> Buffer createBuffer(Command<R, ? super C> command) {
        try {
            return new Buffer(this.marshaller.marshal(command));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class PruneCancellationTask<T>
    implements BiConsumer<T, Throwable> {
        private final Map<Node, CompletionStage<T>> results;
        private final Node member;

        PruneCancellationTask(Map<Node, CompletionStage<T>> results, Node member) {
            this.results = results;
            this.member = member;
        }

        @Override
        public void accept(T result, Throwable exception) {
            if (exception instanceof CancellationException) {
                this.results.remove(this.member);
            }
        }
    }
}

