package org.wildfly.clustering.server.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.infinispan.notifications.cachelistener.event.Event.Type;
import org.jboss.logging.BasicLogger;
import java.util.Collection;
import java.lang.Throwable;
import org.jboss.msc.service.StartException;
import java.lang.Object;
import java.util.Arrays;
import java.util.Map;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-07-02T20:54:56-0500")
public class ClusteringServerLogger_$logger extends DelegatingBasicLogger implements ClusteringServerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ClusteringServerLogger_$logger.class.getName();
    public ClusteringServerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void startSingleton(final String service) {
        super.log.logf(FQCN, INFO, null, startSingleton$str(), service);
    }
    protected String startSingleton$str() {
        return "WFLYCLSV0001: This node will now operate as the singleton provider of the %s service";
    }
    @Override
    public final void stopSingleton(final String service) {
        super.log.logf(FQCN, INFO, null, stopSingleton$str(), service);
    }
    protected String stopSingleton$str() {
        return "WFLYCLSV0002: This node will no longer operate as the singleton provider of the %s service";
    }
    @Override
    public final void elected(final String node, final String service) {
        super.log.logf(FQCN, INFO, null, elected$str(), node, service);
    }
    protected String elected$str() {
        return "WFLYCLSV0003: %s elected as the singleton provider of the %s service";
    }
    protected String noResponseFromMaster$str() {
        return "WFLYCLSV0004: No response received from master node of the %s service, retrying...";
    }
    @Override
    public final IllegalStateException noResponseFromMaster(final String service) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noResponseFromMaster$str(), service));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void serviceStartFailed(final StartException e, final String service) {
        super.log.logf(FQCN, ERROR, e, serviceStartFailed$str(), service);
    }
    protected String serviceStartFailed$str() {
        return "WFLYCLSV0005: Failed to start %s service";
    }
    @Override
    public final void quorumNotReached(final String service, final int quorum) {
        super.log.logf(FQCN, WARN, null, quorumNotReached$str(), service, quorum);
    }
    protected String quorumNotReached$str() {
        return "WFLYCLSV0006: Failed to reach quorum of %2$d for %1$s service. No singleton master will be elected.";
    }
    @Override
    public final void quorumJustReached(final String service, final int quorum) {
        super.log.logf(FQCN, INFO, null, quorumJustReached$str(), service, quorum);
    }
    protected String quorumJustReached$str() {
        return "WFLYCLSV0007: Just reached required quorum of %2$d for %1$s service. If this cluster loses another member, no node will be chosen to provide this service.";
    }
    protected String multiplePrimaryProvidersDetected$str() {
        return "WFLYCLSV0008: Detected multiple primary providers for %s service: %s";
    }
    @Override
    public final IllegalArgumentException multiplePrimaryProvidersDetected(final String serviceName, final Collection<org.wildfly.clustering.group.Node> nodes) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), multiplePrimaryProvidersDetected$str(), serviceName, nodes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notStarted$str() {
        return "WFLYCLSV0009: Singleton service %s is not started.";
    }
    @Override
    public final IllegalStateException notStarted(final String serviceName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notStarted$str(), serviceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void registryPurgeFailed(final Throwable e, final String containerName, final String cacheName, final Collection<?> members) {
        super.log.logf(FQCN, WARN, e, registryPurgeFailed$str(), containerName, cacheName, members);
    }
    protected String registryPurgeFailed$str() {
        return "WFLYCLSV0010: Failed to purge %s/%s registry of old registry entries for: %s";
    }
    @Override
    public final void registryListenerFailed(final Throwable e, final String containerName, final String cacheName, final Type type, final Map<?, ?> entries) {
        super.log.logf(FQCN, WARN, e, registryListenerFailed$str(), containerName, cacheName, type, entries);
    }
    protected String registryListenerFailed$str() {
        return "WFLYCLSV0011: Failed to notify %s/%s registry listener of %s(%s) event";
    }
    @Override
    public final void serviceProviderRegistrationListenerFailed(final Throwable e, final String containerName, final String cacheName, final Set<org.wildfly.clustering.group.Node> providers) {
        super.log.logf(FQCN, WARN, e, serviceProviderRegistrationListenerFailed$str(), containerName, cacheName, providers);
    }
    protected String serviceProviderRegistrationListenerFailed$str() {
        return "WFLYCLSV0012: Failed to notify %s/%s service provider registration listener of new providers: %s";
    }
    @Override
    public final void noPrimaryElected(final String service) {
        super.log.logf(FQCN, WARN, null, noPrimaryElected$str(), service);
    }
    protected String noPrimaryElected$str() {
        return "WFLYCLSV0013: No node was elected as the singleton provider of the %s service";
    }
    protected String invalidQuorum$str() {
        return "WFLYCLSV0014: Specified quorum %d must be greater than zero";
    }
    @Override
    public final IllegalArgumentException invalidQuorum(final int quorum) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidQuorum$str(), quorum));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToRestoreLocalRegistryEntry(final Throwable cause, final String containerName, final String cacheName) {
        super.log.logf(FQCN, WARN, cause, failedToRestoreLocalRegistryEntry$str(), containerName, cacheName);
    }
    protected String failedToRestoreLocalRegistryEntry$str() {
        return "WFLYCLSV0015: Failed to restore local %s/%s registry entry following network partititon merge";
    }
    protected String commandDispatcherAlreadyExists$str() {
        return "WFLYCLSV0016: A command dispatcher already exists for %s";
    }
    @Override
    public final IllegalArgumentException commandDispatcherAlreadyExists(final Object id) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), commandDispatcherAlreadyExists$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String commandDispatcherContextMismatch$str() {
        return "WFLYCLSV0017: A command dispatcher for %s already exists, but with a different command context";
    }
    @Override
    public final IllegalArgumentException commandDispatcherContextMismatch(final Object id) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), commandDispatcherContextMismatch$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
