/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.server.GroupCapabilityServiceConfiguratorFactory;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.GroupServiceConfiguratorProvider;

public class GroupRequirementServiceConfiguratorProvider<T>
implements GroupServiceConfiguratorProvider {
    private final ClusteringRequirement requirement;
    private final GroupCapabilityServiceConfiguratorFactory<T> factory;
    private final Function<String, JndiName> jndiNameFactory;

    protected GroupRequirementServiceConfiguratorProvider(ClusteringRequirement requirement, GroupCapabilityServiceConfiguratorFactory<T> factory) {
        this(requirement, factory, null);
    }

    protected GroupRequirementServiceConfiguratorProvider(ClusteringRequirement requirement, GroupCapabilityServiceConfiguratorFactory<T> factory, Function<String, JndiName> jndiNameFactory) {
        this.requirement = requirement;
        this.factory = factory;
        this.jndiNameFactory = jndiNameFactory;
    }

    public Iterable<CapabilityServiceConfigurator> getServiceConfigurators(ServiceNameRegistry<ClusteringRequirement> registry, String group) {
        ServiceName name = registry.getServiceName((Requirement)this.requirement);
        if (name == null) {
            return Collections.emptySet();
        }
        CapabilityServiceConfigurator configurator = this.factory.createServiceConfigurator(name, group);
        if (this.jndiNameFactory == null) {
            return Collections.singleton(configurator);
        }
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(group).getAbsoluteName());
        BinderServiceConfigurator binderConfigurator = new BinderServiceConfigurator(binding, configurator.getServiceName());
        return Arrays.asList(configurator, binderConfigurator);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

