/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Map;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.MembershipListener;
import org.wildfly.clustering.server.dispatcher.CommandMarshaller;

public class ServiceCommandMarshaller<C>
implements CommandMarshaller<C> {
    private final ServiceName service;
    private final MarshallingContext marshallingContext;
    private final Map<ServiceName, Map.Entry<MembershipListener, Object>> services;
    private final int currentVersion;

    public ServiceCommandMarshaller(ServiceName service, C context, MembershipListener listener, Map<ServiceName, Map.Entry<MembershipListener, Object>> services, MarshallingContext marshallingContext, int currentVersion) {
        this.service = service;
        this.services = services;
        this.services.put(this.service, new AbstractMap.SimpleImmutableEntry<MembershipListener, C>(listener, context));
        this.marshallingContext = marshallingContext;
        this.currentVersion = currentVersion;
    }

    @Override
    public <R> byte[] marshal(Command<R, C> command) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            output.write(this.currentVersion);
            try (Marshaller marshaller = this.marshallingContext.createMarshaller(this.currentVersion);){
                marshaller.start(Marshalling.createByteOutput((OutputStream)output));
                marshaller.writeUTF(this.service.getCanonicalName());
                marshaller.writeObject(command);
                marshaller.flush();
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    @Override
    public void close() {
        this.services.remove(this.service);
    }
}

