/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.clustering.jgroups.Addressable;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.NotifyingFuture;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.server.dispatcher.CommandMarshaller;
import org.wildfly.clustering.server.dispatcher.NoSuchService;

public abstract class ServiceCommandDispatcher<C>
implements CommandDispatcher<C> {
    private static final RspFilter FILTER = new RspFilter(){

        public boolean isAcceptable(Object response, Address sender) {
            return !(response instanceof NoSuchService);
        }

        public boolean needMoreResponses() {
            return true;
        }
    };
    private final MessageDispatcher dispatcher;
    private final CommandMarshaller<C> marshaller;
    private final NodeFactory<Address> factory;
    private final long timeout;

    public ServiceCommandDispatcher(MessageDispatcher dispatcher, CommandMarshaller<C> marshaller, NodeFactory<Address> factory, long timeout) {
        this.dispatcher = dispatcher;
        this.marshaller = marshaller;
        this.factory = factory;
        this.timeout = timeout;
    }

    public <R> Map<Node, CommandResponse<R>> executeOnCluster(Command<R, C> command, Node ... excludedNodes) {
        try {
            RequestOptions options = this.createRequestOptions(excludedNodes);
            RspList responses = this.dispatcher.castMessage(null, this.createMessage(command), options);
            if (responses == null) {
                return Collections.emptyMap();
            }
            HashMap<Node, CommandResponse<R>> results = new HashMap<Node, CommandResponse<R>>();
            for (Map.Entry entry : responses.entrySet()) {
                Address address = (Address)entry.getKey();
                Rsp response = (Rsp)entry.getValue();
                if (!response.wasReceived()) continue;
                results.put(this.factory.createNode((Object)address), ServiceCommandDispatcher.createCommandResponse(response));
            }
            return results;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public <R> Map<Node, Future<R>> submitOnCluster(Command<R, C> command, Node ... excludedNodes) {
        try {
            NotifyingFuture responses = this.dispatcher.castMessageWithFuture(null, this.createMessage(command), this.createRequestOptions(excludedNodes));
            if (responses == null) {
                return Collections.emptyMap();
            }
            HashMap<Node, Future<R>> results = new HashMap<Node, Future<R>>();
            HashSet<Node> excluded = excludedNodes != null ? new HashSet<Node>(Arrays.asList(excludedNodes)) : Collections.emptySet();
            for (Address address : this.dispatcher.getChannel().getView().getMembers()) {
                Node node = this.factory.createNode((Object)address);
                if (excluded.contains(node)) continue;
                Future future = new Future<R>((Future)responses, node){
                    final /* synthetic */ Future val$responses;
                    final /* synthetic */ Node val$node;
                    {
                        this.val$responses = future;
                        this.val$node = node;
                    }

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return this.val$responses.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public R get() throws InterruptedException, ExecutionException {
                        return ServiceCommandDispatcher.createCommandResponse((Rsp)((Map)this.val$responses.get()).get(this.val$node)).get();
                    }

                    @Override
                    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return ServiceCommandDispatcher.createCommandResponse((Rsp)((Map)this.val$responses.get(timeout, unit)).get(this.val$node)).get();
                    }

                    @Override
                    public boolean isCancelled() {
                        return this.val$responses.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return this.val$responses.isDone();
                    }
                };
                results.put(node, future);
            }
            return results;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public <R> CommandResponse<R> executeOnNode(Command<R, C> command, Node node) {
        try {
            Object result = this.dispatcher.sendMessage(this.createMessage(command, node), this.createRequestOptions());
            return new SimpleCommandResponse<Object>(result);
        }
        catch (Throwable e) {
            return new SimpleCommandResponse(e);
        }
    }

    public <R> Future<R> submitOnNode(Command<R, C> command, Node node) {
        try {
            return this.dispatcher.sendMessageWithFuture(this.createMessage(command, node), this.createRequestOptions());
        }
        catch (Throwable e) {
            return new SimpleFuture(e);
        }
    }

    private <R> Message createMessage(Command<R, C> command) {
        try {
            return new Message(null, this.getLocalAddress(), this.marshaller.marshal(command));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private <R> Message createMessage(Command<R, C> command, Node node) {
        try {
            return new Message(ServiceCommandDispatcher.getAddress(node), this.getLocalAddress(), this.marshaller.marshal(command));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Address getAddress(Node node) {
        if (node instanceof Addressable) {
            return ((Addressable)node).getAddress();
        }
        throw new IllegalArgumentException(node.getName());
    }

    private RequestOptions createRequestOptions(Node ... excludedNodes) {
        RequestOptions options = this.createRequestOptions();
        if (excludedNodes != null && excludedNodes.length > 0) {
            Address[] addresses = new Address[excludedNodes.length];
            for (int i = 0; i < excludedNodes.length; ++i) {
                addresses[i] = ServiceCommandDispatcher.getAddress(excludedNodes[i]);
            }
            options.setExclusionList(addresses);
        }
        return options;
    }

    private RequestOptions createRequestOptions() {
        return new RequestOptions(ResponseMode.GET_ALL, this.timeout, false, FILTER, new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    }

    static <R> CommandResponse<R> createCommandResponse(Rsp<R> response) {
        Throwable exception = response.getException();
        return exception != null ? new SimpleCommandResponse(exception) : new SimpleCommandResponse<Object>(response.wasReceived() ? response.getValue() : null);
    }

    private Address getLocalAddress() {
        return this.dispatcher.getChannel().getAddress();
    }

    private static class SimpleFuture<T>
    extends SimpleCommandResponse<T>
    implements Future<T> {
        SimpleFuture(T value) {
            super(value);
        }

        SimpleFuture(Throwable exception) {
            super(exception);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws ExecutionException {
            return this.get();
        }
    }

    private static class SimpleCommandResponse<T>
    implements CommandResponse<T> {
        private final T value;
        private final ExecutionException exception;

        SimpleCommandResponse(T value) {
            this.value = value;
            this.exception = null;
        }

        SimpleCommandResponse(Throwable exception) {
            this.value = null;
            this.exception = new ExecutionException(exception);
        }

        public T get() throws ExecutionException {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
    }
}

