/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton.election;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.election.Preference;
import org.wildfly.clustering.singleton.election.PreferredSingletonElectionPolicy;

public class PreferredSingletonElectionPolicyTestCase {
    @Test
    public void elect() {
        SingletonElectionPolicy policy = (SingletonElectionPolicy)Mockito.mock(SingletonElectionPolicy.class);
        Preference preference1 = (Preference)Mockito.mock(Preference.class);
        Preference preference2 = (Preference)Mockito.mock(Preference.class);
        Node node1 = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Node node3 = (Node)Mockito.mock(Node.class);
        Node node4 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)preference1.preferred((Node)ArgumentMatchers.same((Object)node1))).thenReturn((Object)true);
        Mockito.when((Object)preference1.preferred((Node)ArgumentMatchers.same((Object)node2))).thenReturn((Object)false);
        Mockito.when((Object)preference1.preferred((Node)ArgumentMatchers.same((Object)node3))).thenReturn((Object)false);
        Mockito.when((Object)preference1.preferred((Node)ArgumentMatchers.same((Object)node4))).thenReturn((Object)false);
        Mockito.when((Object)preference2.preferred((Node)ArgumentMatchers.same((Object)node1))).thenReturn((Object)false);
        Mockito.when((Object)preference2.preferred((Node)ArgumentMatchers.same((Object)node2))).thenReturn((Object)true);
        Mockito.when((Object)preference2.preferred((Node)ArgumentMatchers.same((Object)node3))).thenReturn((Object)false);
        Mockito.when((Object)preference2.preferred((Node)ArgumentMatchers.same((Object)node4))).thenReturn((Object)false);
        Assert.assertSame((Object)node1, (Object)new PreferredSingletonElectionPolicy(policy, new Preference[]{preference1, preference2}).elect(Arrays.asList(node1, node2, node3, node4)));
        Assert.assertSame((Object)node1, (Object)new PreferredSingletonElectionPolicy(policy, new Preference[]{preference1, preference2}).elect(Arrays.asList(node4, node3, node2, node1)));
        Assert.assertSame((Object)node2, (Object)new PreferredSingletonElectionPolicy(policy, new Preference[]{preference1, preference2}).elect(Arrays.asList(node2, node3, node4)));
        Assert.assertSame((Object)node2, (Object)new PreferredSingletonElectionPolicy(policy, new Preference[]{preference1, preference2}).elect(Arrays.asList(node4, node3, node2)));
        List<Node> nodes = Arrays.asList(node3, node4);
        Mockito.when((Object)policy.elect(nodes)).thenReturn((Object)node3);
        Assert.assertSame((Object)node3, (Object)new PreferredSingletonElectionPolicy(policy, new Preference[]{preference1, preference2}).elect(nodes));
        Mockito.when((Object)policy.elect(nodes)).thenReturn((Object)node4);
        Assert.assertSame((Object)node4, (Object)new PreferredSingletonElectionPolicy(policy, new Preference[]{preference1, preference2}).elect(nodes));
        Mockito.when((Object)policy.elect(nodes)).thenReturn(null);
        Assert.assertNull((Object)new PreferredSingletonElectionPolicy(policy, new Preference[]{preference1, preference2}).elect(nodes));
    }
}

