/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.clustering.singleton.ElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SimpleElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonSchema;
import org.wildfly.extension.clustering.singleton.XMLAttribute;
import org.wildfly.extension.clustering.singleton.XMLElement;

public class SingletonXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(SingletonSchema.CURRENT.getNamespaceUri(), false);
        SingletonXMLWriter.writeSingletonPolicies(writer, context.getModelNode());
        writer.writeEndElement();
    }

    private static void writeSingletonPolicies(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(XMLElement.SINGLETON_POLICIES.getLocalName());
        SingletonXMLWriter.writeAttributes(writer, model, SingletonResourceDefinition.Attribute.class);
        for (Property property : model.get(SingletonPolicyResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
            SingletonXMLWriter.writeSingletonPolicy(writer, property.getName(), property.getValue());
        }
        writer.writeEndElement();
    }

    private static void writeSingletonPolicy(XMLExtendedStreamWriter writer, String name, ModelNode policy) throws XMLStreamException {
        writer.writeStartElement(XMLElement.SINGLETON_POLICY.getLocalName());
        writer.writeAttribute(XMLAttribute.NAME.getLocalName(), name);
        SingletonXMLWriter.writeAttributes(writer, policy, SingletonPolicyResourceDefinition.Attribute.class);
        if (policy.hasDefined(ElectionPolicyResourceDefinition.WILDCARD_PATH.getKey())) {
            Property property = policy.get(ElectionPolicyResourceDefinition.WILDCARD_PATH.getKey()).asProperty();
            SingletonXMLWriter.writeElectionPolicy(writer, property.getName(), property.getValue());
        }
        writer.writeEndElement();
    }

    private static void writeElectionPolicy(XMLExtendedStreamWriter writer, String name, ModelNode policy) throws XMLStreamException {
        switch (name) {
            case "random": {
                writer.writeStartElement(XMLElement.RANDOM_ELECTION_POLICY.getLocalName());
                break;
            }
            case "simple": {
                writer.writeStartElement(XMLElement.SIMPLE_ELECTION_POLICY.getLocalName());
                SingletonXMLWriter.writeAttributes(writer, policy, SimpleElectionPolicyResourceDefinition.Attribute.class);
                break;
            }
            default: {
                throw new IllegalArgumentException(name);
            }
        }
        SingletonXMLWriter.writeElements(writer, policy, ElectionPolicyResourceDefinition.Attribute.class);
        writer.writeEndElement();
    }

    private static <A extends Enum<A>> void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Class<A> attributeClass) throws XMLStreamException {
        SingletonXMLWriter.writeAttributes(writer, model, EnumSet.allOf(attributeClass));
    }

    private static void writeAttributes(XMLExtendedStreamWriter writer, ModelNode model, Iterable<? extends Attribute> attributes) throws XMLStreamException {
        for (Attribute attribute : attributes) {
            SingletonXMLWriter.writeAttribute(writer, model, attribute);
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getMarshaller().marshallAsAttribute((AttributeDefinition)attribute.getDefinition(), model, false, (XMLStreamWriter)writer);
    }

    private static <A extends Enum<A>> void writeElements(XMLExtendedStreamWriter writer, ModelNode model, Class<A> attributeClass) throws XMLStreamException {
        SingletonXMLWriter.writeElements(writer, model, EnumSet.allOf(attributeClass));
    }

    private static void writeElements(XMLExtendedStreamWriter writer, ModelNode model, Iterable<? extends Attribute> attributes) throws XMLStreamException {
        for (Attribute attribute : attributes) {
            SingletonXMLWriter.writeElement(writer, model, attribute);
        }
    }

    private static void writeElement(XMLExtendedStreamWriter writer, ModelNode model, Attribute attribute) throws XMLStreamException {
        ((AttributeDefinition)attribute.getDefinition()).getMarshaller().marshallAsElement((AttributeDefinition)attribute.getDefinition(), model, false, (XMLStreamWriter)writer);
    }
}

