/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EnumSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.staxmapper.IntVersion;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.extension.clustering.singleton.deployment.MutableSingletonDeploymentConfiguration;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentSchema;

@RunWith(value=Parameterized.class)
public class SingletonDeploymentSchemaTestCase {
    private final SingletonDeploymentSchema schema;

    @Parameterized.Parameters
    public static Iterable<SingletonDeploymentSchema> parameters() {
        return EnumSet.allOf(SingletonDeploymentSchema.class);
    }

    public SingletonDeploymentSchemaTestCase(SingletonDeploymentSchema schema) {
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws IOException, XMLStreamException {
        URL url = this.getClass().getResource(String.format("singleton-deployment-%d.%d.xml", ((IntVersion)this.schema.getVersion()).major(), ((IntVersion)this.schema.getVersion()).minor()));
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(this.schema.getQualifiedName(), (XMLElementReader)this.schema);
        try (InputStream input = url.openStream();){
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            MutableSingletonDeploymentConfiguration config = new MutableSingletonDeploymentConfiguration(PropertyReplacers.noop());
            mapper.parseDocument((Object)config, reader);
            Assert.assertEquals((Object)"foo", (Object)config.getPolicy());
        }
        finally {
            mapper.unregisterRootAttribute(this.schema.getQualifiedName());
        }
    }
}

