/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.EnumSet;
import java.util.List;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.singleton.service.SingletonServiceConfiguratorFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory;
import org.wildfly.extension.clustering.singleton.SingletonExtension;
import org.wildfly.extension.clustering.singleton.SingletonSubsystemModel;
import org.wildfly.extension.clustering.singleton.SingletonSubsystemResourceDefinitionRegistrar;

@RunWith(value=Parameterized.class)
public class SingletonTransformersTestCase
extends AbstractSubsystemTest {
    private final ModelTestControllerVersion controllerVersion;
    private final ModelVersion version;

    @Parameterized.Parameters
    public static Iterable<ModelTestControllerVersion> parameters() {
        return EnumSet.of(ModelTestControllerVersion.EAP_7_4_0, ModelTestControllerVersion.EAP_8_0_0, ModelTestControllerVersion.EAP_8_1_0);
    }

    public SingletonTransformersTestCase(ModelTestControllerVersion controllerVersion) {
        super(SingletonSubsystemResourceDefinitionRegistrar.REGISTRATION.getName(), (Extension)new SingletonExtension());
        this.controllerVersion = controllerVersion;
        this.version = this.getModelVersion().getVersion();
    }

    private SingletonSubsystemModel getModelVersion() {
        switch (this.controllerVersion) {
            case EAP_7_4_0: 
            case EAP_8_0_0: 
            case EAP_8_1_0: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return SingletonSubsystemModel.VERSION_3_0_0;
    }

    private String[] getDependencies() {
        String[] stringArray;
        switch (this.controllerVersion) {
            case EAP_7_4_0: {
                String[] stringArray2 = new String[7];
                stringArray2[0] = this.createGAV("wildfly-clustering-singleton-extension");
                stringArray2[1] = this.createGAV("wildfly-clustering-api");
                stringArray2[2] = this.createGAV("wildfly-clustering-common");
                stringArray2[3] = this.createGAV("wildfly-clustering-server");
                stringArray2[4] = this.createGAV("wildfly-clustering-service");
                stringArray2[5] = this.createGAV("wildfly-clustering-singleton-api");
                stringArray = stringArray2;
                stringArray2[6] = this.createGAV("wildfly-clustering-spi");
                break;
            }
            case EAP_8_0_0: {
                String[] stringArray3 = new String[4];
                stringArray3[0] = this.createGAV("wildfly-clustering-singleton-extension");
                stringArray3[1] = this.createGAV("wildfly-clustering-common");
                stringArray3[2] = this.createGAV("wildfly-clustering-service");
                stringArray = stringArray3;
                stringArray3[3] = this.createGAV("wildfly-clustering-singleton-api");
                break;
            }
            case EAP_8_1_0: {
                String[] stringArray4 = new String[5];
                stringArray4[0] = this.createGAV("wildfly-clustering-singleton-extension");
                stringArray4[1] = this.createGAV("wildfly-clustering-common");
                stringArray4[2] = this.createGAV("wildfly-clustering-server-service");
                stringArray4[3] = this.createGAV("wildfly-clustering-singleton-api");
                stringArray = stringArray4;
                stringArray4[4] = this.createCoreGAV("wildfly-subsystem");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return stringArray;
    }

    public String createGAV(String artifactId) {
        return String.format("%s:%s:%s", this.controllerVersion.getMavenGroupId(), artifactId, this.controllerVersion.getMavenGavVersion());
    }

    public String createCoreGAV(String artifactId) {
        return String.format("%s:%s:%s", this.controllerVersion.getCoreMavenGroupId(), artifactId, this.controllerVersion.getCoreVersion());
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "binding0").require(OutboundSocketBinding.SERVICE_DESCRIPTOR, "binding1").require(InfinispanServiceDescriptor.DEFAULT_CACHE_CONFIGURATION, "singleton-container").require(SingletonServiceTargetFactory.DEFAULT_SERVICE_DESCRIPTOR, "singleton-container").require(SingletonServiceConfiguratorFactory.DEFAULT_SERVICE_DESCRIPTOR, "singleton-container").require(InfinispanServiceDescriptor.CACHE_CONFIGURATION, "singleton-container", "singleton-cache").require(SingletonServiceTargetFactory.SERVICE_DESCRIPTOR, "singleton-container", "singleton-cache").require(SingletonServiceConfiguratorFactory.SERVICE_DESCRIPTOR, "singleton-container", "singleton-cache");
    }

    @Test
    public void testTransformation() throws Exception {
        String subsystemXmlResource = String.format("singleton-transform-%s.xml", this.version);
        KernelServices services = this.buildKernelServices(subsystemXmlResource, this.controllerVersion, this.version, this.getDependencies());
        this.checkSubsystemModelTransformation(services, this.version, null, false);
    }

    @Test
    public void testRejections() throws Exception {
        KernelServicesBuilder builder = this.createKernelServicesBuilder();
        builder.createLegacyKernelServicesBuilder(this.createAdditionalInitialization(), this.controllerVersion, this.version).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addMavenResourceURL(this.getDependencies());
        KernelServices services = builder.build();
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(this.version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List xmlOps = builder.parseXmlResource("singleton-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)this.version, (List)xmlOps, (FailedOperationTransformationConfig)SingletonTransformersTestCase.createFailedOperationConfig(this.version));
    }

    private static FailedOperationTransformationConfig createFailedOperationConfig(ModelVersion version) {
        return new FailedOperationTransformationConfig();
    }

    private KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder(this.createAdditionalInitialization());
    }

    private KernelServices buildKernelServices(String subsystemXml, ModelTestControllerVersion controllerVersion, ModelVersion version, String ... mavenResourceURLs) throws Exception {
        KernelServicesBuilder builder = this.createKernelServicesBuilder().setSubsystemXmlResource(subsystemXml);
        builder.createLegacyKernelServicesBuilder(this.createAdditionalInitialization(), controllerVersion, version).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addMavenResourceURL(mavenResourceURLs).skipReverseControllerCheck();
        KernelServices services = builder.build();
        Assert.assertTrue((String)(ModelTestControllerVersion.MASTER + " boot failed"), (boolean)services.isSuccessfulBoot());
        Assert.assertTrue((String)(controllerVersion.getMavenGavVersion() + " boot failed"), (boolean)((KernelServices)services.getLegacyServices(version)).isSuccessfulBoot());
        return services;
    }
}

